package hitsdb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetLdpsNamespacedQuota invokes the hitsdb.GetLdpsNamespacedQuota API synchronously
func (client *Client) GetLdpsNamespacedQuota(request *GetLdpsNamespacedQuotaRequest) (response *GetLdpsNamespacedQuotaResponse, err error) {
	response = CreateGetLdpsNamespacedQuotaResponse()
	err = client.DoAction(request, response)
	return
}

// GetLdpsNamespacedQuotaWithChan invokes the hitsdb.GetLdpsNamespacedQuota API asynchronously
func (client *Client) GetLdpsNamespacedQuotaWithChan(request *GetLdpsNamespacedQuotaRequest) (<-chan *GetLdpsNamespacedQuotaResponse, <-chan error) {
	responseChan := make(chan *GetLdpsNamespacedQuotaResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetLdpsNamespacedQuota(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetLdpsNamespacedQuotaWithCallback invokes the hitsdb.GetLdpsNamespacedQuota API asynchronously
func (client *Client) GetLdpsNamespacedQuotaWithCallback(request *GetLdpsNamespacedQuotaRequest, callback func(response *GetLdpsNamespacedQuotaResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetLdpsNamespacedQuotaResponse
		var err error
		defer close(result)
		response, err = client.GetLdpsNamespacedQuota(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetLdpsNamespacedQuotaRequest is the request struct for api GetLdpsNamespacedQuota
type GetLdpsNamespacedQuotaRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	SecurityToken        string           `position:"Query" name:"SecurityToken"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	InstanceId           string           `position:"Query" name:"InstanceId"`
	Namespace            string           `position:"Query" name:"Namespace"`
}

// GetLdpsNamespacedQuotaResponse is the response struct for api GetLdpsNamespacedQuota
type GetLdpsNamespacedQuotaResponse struct {
	*responses.BaseResponse
	RequestId        string            `json:"RequestId" xml:"RequestId"`
	NamespacedQuotas []NamespacedQuota `json:"NamespacedQuotas" xml:"NamespacedQuotas"`
}

// CreateGetLdpsNamespacedQuotaRequest creates a request to invoke GetLdpsNamespacedQuota API
func CreateGetLdpsNamespacedQuotaRequest() (request *GetLdpsNamespacedQuotaRequest) {
	request = &GetLdpsNamespacedQuotaRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("hitsdb", "2020-06-15", "GetLdpsNamespacedQuota", "hitsdb", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetLdpsNamespacedQuotaResponse creates a response to parse from GetLdpsNamespacedQuota response
func CreateGetLdpsNamespacedQuotaResponse() (response *GetLdpsNamespacedQuotaResponse) {
	response = &GetLdpsNamespacedQuotaResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
