package ims

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RemoveFingerprintFromOIDCProvider invokes the ims.RemoveFingerprintFromOIDCProvider API synchronously
func (client *Client) RemoveFingerprintFromOIDCProvider(request *RemoveFingerprintFromOIDCProviderRequest) (response *RemoveFingerprintFromOIDCProviderResponse, err error) {
	response = CreateRemoveFingerprintFromOIDCProviderResponse()
	err = client.DoAction(request, response)
	return
}

// RemoveFingerprintFromOIDCProviderWithChan invokes the ims.RemoveFingerprintFromOIDCProvider API asynchronously
func (client *Client) RemoveFingerprintFromOIDCProviderWithChan(request *RemoveFingerprintFromOIDCProviderRequest) (<-chan *RemoveFingerprintFromOIDCProviderResponse, <-chan error) {
	responseChan := make(chan *RemoveFingerprintFromOIDCProviderResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RemoveFingerprintFromOIDCProvider(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RemoveFingerprintFromOIDCProviderWithCallback invokes the ims.RemoveFingerprintFromOIDCProvider API asynchronously
func (client *Client) RemoveFingerprintFromOIDCProviderWithCallback(request *RemoveFingerprintFromOIDCProviderRequest, callback func(response *RemoveFingerprintFromOIDCProviderResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RemoveFingerprintFromOIDCProviderResponse
		var err error
		defer close(result)
		response, err = client.RemoveFingerprintFromOIDCProvider(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RemoveFingerprintFromOIDCProviderRequest is the request struct for api RemoveFingerprintFromOIDCProvider
type RemoveFingerprintFromOIDCProviderRequest struct {
	*requests.RpcRequest
	AkProxySuffix    string `position:"Query" name:"AkProxySuffix"`
	OIDCProviderName string `position:"Query" name:"OIDCProviderName"`
	Fingerprint      string `position:"Query" name:"Fingerprint"`
}

// RemoveFingerprintFromOIDCProviderResponse is the response struct for api RemoveFingerprintFromOIDCProvider
type RemoveFingerprintFromOIDCProviderResponse struct {
	*responses.BaseResponse
	RequestId    string       `json:"RequestId" xml:"RequestId"`
	OIDCProvider OIDCProvider `json:"OIDCProvider" xml:"OIDCProvider"`
}

// CreateRemoveFingerprintFromOIDCProviderRequest creates a request to invoke RemoveFingerprintFromOIDCProvider API
func CreateRemoveFingerprintFromOIDCProviderRequest() (request *RemoveFingerprintFromOIDCProviderRequest) {
	request = &RemoveFingerprintFromOIDCProviderRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ims", "2019-08-15", "RemoveFingerprintFromOIDCProvider", "ims", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRemoveFingerprintFromOIDCProviderResponse creates a response to parse from RemoveFingerprintFromOIDCProvider response
func CreateRemoveFingerprintFromOIDCProviderResponse() (response *RemoveFingerprintFromOIDCProviderResponse) {
	response = &RemoveFingerprintFromOIDCProviderResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
