package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetSceneRule invokes the iot.GetSceneRule API synchronously
func (client *Client) GetSceneRule(request *GetSceneRuleRequest) (response *GetSceneRuleResponse, err error) {
	response = CreateGetSceneRuleResponse()
	err = client.DoAction(request, response)
	return
}

// GetSceneRuleWithChan invokes the iot.GetSceneRule API asynchronously
func (client *Client) GetSceneRuleWithChan(request *GetSceneRuleRequest) (<-chan *GetSceneRuleResponse, <-chan error) {
	responseChan := make(chan *GetSceneRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetSceneRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetSceneRuleWithCallback invokes the iot.GetSceneRule API asynchronously
func (client *Client) GetSceneRuleWithCallback(request *GetSceneRuleRequest, callback func(response *GetSceneRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetSceneRuleResponse
		var err error
		defer close(result)
		response, err = client.GetSceneRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetSceneRuleRequest is the request struct for api GetSceneRule
type GetSceneRuleRequest struct {
	*requests.RpcRequest
	IotInstanceId string `position:"Query" name:"IotInstanceId"`
	ApiProduct    string `position:"Body" name:"ApiProduct"`
	ApiRevision   string `position:"Body" name:"ApiRevision"`
	RuleId        string `position:"Query" name:"RuleId"`
}

// GetSceneRuleResponse is the response struct for api GetSceneRule
type GetSceneRuleResponse struct {
	*responses.BaseResponse
	RequestId    string             `json:"RequestId" xml:"RequestId"`
	Success      bool               `json:"Success" xml:"Success"`
	ErrorMessage string             `json:"ErrorMessage" xml:"ErrorMessage"`
	Code         string             `json:"Code" xml:"Code"`
	Data         DataInGetSceneRule `json:"Data" xml:"Data"`
}

// CreateGetSceneRuleRequest creates a request to invoke GetSceneRule API
func CreateGetSceneRuleRequest() (request *GetSceneRuleRequest) {
	request = &GetSceneRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "GetSceneRule", "iot", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetSceneRuleResponse creates a response to parse from GetSceneRule response
func CreateGetSceneRuleResponse() (response *GetSceneRuleResponse) {
	response = &GetSceneRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
