package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryDeviceOriginalPropertyData invokes the iot.QueryDeviceOriginalPropertyData API synchronously
func (client *Client) QueryDeviceOriginalPropertyData(request *QueryDeviceOriginalPropertyDataRequest) (response *QueryDeviceOriginalPropertyDataResponse, err error) {
	response = CreateQueryDeviceOriginalPropertyDataResponse()
	err = client.DoAction(request, response)
	return
}

// QueryDeviceOriginalPropertyDataWithChan invokes the iot.QueryDeviceOriginalPropertyData API asynchronously
func (client *Client) QueryDeviceOriginalPropertyDataWithChan(request *QueryDeviceOriginalPropertyDataRequest) (<-chan *QueryDeviceOriginalPropertyDataResponse, <-chan error) {
	responseChan := make(chan *QueryDeviceOriginalPropertyDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryDeviceOriginalPropertyData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryDeviceOriginalPropertyDataWithCallback invokes the iot.QueryDeviceOriginalPropertyData API asynchronously
func (client *Client) QueryDeviceOriginalPropertyDataWithCallback(request *QueryDeviceOriginalPropertyDataRequest, callback func(response *QueryDeviceOriginalPropertyDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryDeviceOriginalPropertyDataResponse
		var err error
		defer close(result)
		response, err = client.QueryDeviceOriginalPropertyData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryDeviceOriginalPropertyDataRequest is the request struct for api QueryDeviceOriginalPropertyData
type QueryDeviceOriginalPropertyDataRequest struct {
	*requests.RpcRequest
	NextPageToken string           `position:"Query" name:"NextPageToken"`
	StartTime     requests.Integer `position:"Query" name:"StartTime"`
	IotId         string           `position:"Query" name:"IotId"`
	IotInstanceId string           `position:"Query" name:"IotInstanceId"`
	PageSize      requests.Integer `position:"Query" name:"PageSize"`
	Identifier    string           `position:"Query" name:"Identifier"`
	EndTime       requests.Integer `position:"Query" name:"EndTime"`
	ProductKey    string           `position:"Query" name:"ProductKey"`
	Asc           requests.Integer `position:"Query" name:"Asc"`
	ApiProduct    string           `position:"Body" name:"ApiProduct"`
	ApiRevision   string           `position:"Body" name:"ApiRevision"`
	DeviceName    string           `position:"Query" name:"DeviceName"`
}

// QueryDeviceOriginalPropertyDataResponse is the response struct for api QueryDeviceOriginalPropertyData
type QueryDeviceOriginalPropertyDataResponse struct {
	*responses.BaseResponse
	RequestId    string                                `json:"RequestId" xml:"RequestId"`
	Success      bool                                  `json:"Success" xml:"Success"`
	Code         string                                `json:"Code" xml:"Code"`
	ErrorMessage string                                `json:"ErrorMessage" xml:"ErrorMessage"`
	Data         DataInQueryDeviceOriginalPropertyData `json:"Data" xml:"Data"`
}

// CreateQueryDeviceOriginalPropertyDataRequest creates a request to invoke QueryDeviceOriginalPropertyData API
func CreateQueryDeviceOriginalPropertyDataRequest() (request *QueryDeviceOriginalPropertyDataRequest) {
	request = &QueryDeviceOriginalPropertyDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "QueryDeviceOriginalPropertyData", "iot", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQueryDeviceOriginalPropertyDataResponse creates a response to parse from QueryDeviceOriginalPropertyData response
func CreateQueryDeviceOriginalPropertyDataResponse() (response *QueryDeviceOriginalPropertyDataResponse) {
	response = &QueryDeviceOriginalPropertyDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
