package ledgerdb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetMember invokes the ledgerdb.GetMember API synchronously
// api document: https://help.aliyun.com/api/ledgerdb/getmember.html
func (client *Client) GetMember(request *GetMemberRequest) (response *GetMemberResponse, err error) {
	response = CreateGetMemberResponse()
	err = client.DoAction(request, response)
	return
}

// GetMemberWithChan invokes the ledgerdb.GetMember API asynchronously
// api document: https://help.aliyun.com/api/ledgerdb/getmember.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetMemberWithChan(request *GetMemberRequest) (<-chan *GetMemberResponse, <-chan error) {
	responseChan := make(chan *GetMemberResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetMember(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetMemberWithCallback invokes the ledgerdb.GetMember API asynchronously
// api document: https://help.aliyun.com/api/ledgerdb/getmember.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetMemberWithCallback(request *GetMemberRequest, callback func(response *GetMemberResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetMemberResponse
		var err error
		defer close(result)
		response, err = client.GetMember(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetMemberRequest is the request struct for api GetMember
type GetMemberRequest struct {
	*requests.RpcRequest
	LedgerId string `position:"Query" name:"LedgerId"`
	MemberId string `position:"Query" name:"MemberId"`
}

// GetMemberResponse is the response struct for api GetMember
type GetMemberResponse struct {
	*responses.BaseResponse
	RequestId  string `json:"RequestId" xml:"RequestId"`
	LedgerId   string `json:"LedgerId" xml:"LedgerId"`
	MemberId   string `json:"MemberId" xml:"MemberId"`
	AliUid     string `json:"AliUid" xml:"AliUid"`
	KeyType    string `json:"KeyType" xml:"KeyType"`
	PublicKey  string `json:"PublicKey" xml:"PublicKey"`
	Role       string `json:"Role" xml:"Role"`
	State      string `json:"State" xml:"State"`
	CreateTime int64  `json:"CreateTime" xml:"CreateTime"`
	UpdateTime int64  `json:"UpdateTime" xml:"UpdateTime"`
}

// CreateGetMemberRequest creates a request to invoke GetMember API
func CreateGetMemberRequest() (request *GetMemberRequest) {
	request = &GetMemberRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ledgerdb", "2019-11-22", "GetMember", "ledgerdb", "openAPI")
	return
}

// CreateGetMemberResponse creates a response to parse from GetMember response
func CreateGetMemberResponse() (response *GetMemberResponse) {
	response = &GetMemberResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
