package linkface

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SyncFacePictures invokes the linkface.SyncFacePictures API synchronously
// api document: https://help.aliyun.com/api/linkface/syncfacepictures.html
func (client *Client) SyncFacePictures(request *SyncFacePicturesRequest) (response *SyncFacePicturesResponse, err error) {
	response = CreateSyncFacePicturesResponse()
	err = client.DoAction(request, response)
	return
}

// SyncFacePicturesWithChan invokes the linkface.SyncFacePictures API asynchronously
// api document: https://help.aliyun.com/api/linkface/syncfacepictures.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SyncFacePicturesWithChan(request *SyncFacePicturesRequest) (<-chan *SyncFacePicturesResponse, <-chan error) {
	responseChan := make(chan *SyncFacePicturesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SyncFacePictures(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SyncFacePicturesWithCallback invokes the linkface.SyncFacePictures API asynchronously
// api document: https://help.aliyun.com/api/linkface/syncfacepictures.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SyncFacePicturesWithCallback(request *SyncFacePicturesRequest, callback func(response *SyncFacePicturesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SyncFacePicturesResponse
		var err error
		defer close(result)
		response, err = client.SyncFacePictures(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SyncFacePicturesRequest is the request struct for api SyncFacePictures
type SyncFacePicturesRequest struct {
	*requests.RpcRequest
	IotId      string `position:"Body" name:"IotId"`
	GroupId    string `position:"Body" name:"GroupId"`
	DeviceName string `position:"Body" name:"DeviceName"`
	ProductKey string `position:"Body" name:"ProductKey"`
}

// SyncFacePicturesResponse is the response struct for api SyncFacePictures
type SyncFacePicturesResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateSyncFacePicturesRequest creates a request to invoke SyncFacePictures API
func CreateSyncFacePicturesRequest() (request *SyncFacePicturesRequest) {
	request = &SyncFacePicturesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("LinkFace", "2018-07-20", "SyncFacePictures", "", "")
	return
}

// CreateSyncFacePicturesResponse creates a response to parse from SyncFacePictures response
func CreateSyncFacePicturesResponse() (response *SyncFacePicturesResponse) {
	response = &SyncFacePicturesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
