package linkwan

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListFreqBandPlanGroups invokes the linkwan.ListFreqBandPlanGroups API synchronously
func (client *Client) ListFreqBandPlanGroups(request *ListFreqBandPlanGroupsRequest) (response *ListFreqBandPlanGroupsResponse, err error) {
	response = CreateListFreqBandPlanGroupsResponse()
	err = client.DoAction(request, response)
	return
}

// ListFreqBandPlanGroupsWithChan invokes the linkwan.ListFreqBandPlanGroups API asynchronously
func (client *Client) ListFreqBandPlanGroupsWithChan(request *ListFreqBandPlanGroupsRequest) (<-chan *ListFreqBandPlanGroupsResponse, <-chan error) {
	responseChan := make(chan *ListFreqBandPlanGroupsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListFreqBandPlanGroups(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListFreqBandPlanGroupsWithCallback invokes the linkwan.ListFreqBandPlanGroups API asynchronously
func (client *Client) ListFreqBandPlanGroupsWithCallback(request *ListFreqBandPlanGroupsRequest, callback func(response *ListFreqBandPlanGroupsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListFreqBandPlanGroupsResponse
		var err error
		defer close(result)
		response, err = client.ListFreqBandPlanGroups(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListFreqBandPlanGroupsRequest is the request struct for api ListFreqBandPlanGroups
type ListFreqBandPlanGroupsRequest struct {
	*requests.RpcRequest
	ApiProduct  string `position:"Body" name:"ApiProduct"`
	ApiRevision string `position:"Body" name:"ApiRevision"`
}

// ListFreqBandPlanGroupsResponse is the response struct for api ListFreqBandPlanGroups
type ListFreqBandPlanGroupsResponse struct {
	*responses.BaseResponse
	RequestId string  `json:"RequestId" xml:"RequestId"`
	Success   bool    `json:"Success" xml:"Success"`
	Data      []Group `json:"Data" xml:"Data"`
}

// CreateListFreqBandPlanGroupsRequest creates a request to invoke ListFreqBandPlanGroups API
func CreateListFreqBandPlanGroupsRequest() (request *ListFreqBandPlanGroupsRequest) {
	request = &ListFreqBandPlanGroupsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("LinkWAN", "2019-03-01", "ListFreqBandPlanGroups", "linkwan", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListFreqBandPlanGroupsResponse creates a response to parse from ListFreqBandPlanGroups response
func CreateListFreqBandPlanGroupsResponse() (response *ListFreqBandPlanGroupsResponse) {
	response = &ListFreqBandPlanGroupsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
