package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CloseLiveShift invokes the live.CloseLiveShift API synchronously
func (client *Client) CloseLiveShift(request *CloseLiveShiftRequest) (response *CloseLiveShiftResponse, err error) {
	response = CreateCloseLiveShiftResponse()
	err = client.DoAction(request, response)
	return
}

// CloseLiveShiftWithChan invokes the live.CloseLiveShift API asynchronously
func (client *Client) CloseLiveShiftWithChan(request *CloseLiveShiftRequest) (<-chan *CloseLiveShiftResponse, <-chan error) {
	responseChan := make(chan *CloseLiveShiftResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CloseLiveShift(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CloseLiveShiftWithCallback invokes the live.CloseLiveShift API asynchronously
func (client *Client) CloseLiveShiftWithCallback(request *CloseLiveShiftRequest, callback func(response *CloseLiveShiftResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CloseLiveShiftResponse
		var err error
		defer close(result)
		response, err = client.CloseLiveShift(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CloseLiveShiftRequest is the request struct for api CloseLiveShift
type CloseLiveShiftRequest struct {
	*requests.RpcRequest
	AppName    string           `position:"Query" name:"AppName"`
	StreamName string           `position:"Query" name:"StreamName"`
	DomainName string           `position:"Query" name:"DomainName"`
	OwnerId    requests.Integer `position:"Query" name:"OwnerId"`
}

// CloseLiveShiftResponse is the response struct for api CloseLiveShift
type CloseLiveShiftResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateCloseLiveShiftRequest creates a request to invoke CloseLiveShift API
func CreateCloseLiveShiftRequest() (request *CloseLiveShiftRequest) {
	request = &CloseLiveShiftRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "CloseLiveShift", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCloseLiveShiftResponse creates a response to parse from CloseLiveShift response
func CreateCloseLiveShiftResponse() (response *CloseLiveShiftResponse) {
	response = &CloseLiveShiftResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
