package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// HotLiveRtcStream invokes the live.HotLiveRtcStream API synchronously
func (client *Client) HotLiveRtcStream(request *HotLiveRtcStreamRequest) (response *HotLiveRtcStreamResponse, err error) {
	response = CreateHotLiveRtcStreamResponse()
	err = client.DoAction(request, response)
	return
}

// HotLiveRtcStreamWithChan invokes the live.HotLiveRtcStream API asynchronously
func (client *Client) HotLiveRtcStreamWithChan(request *HotLiveRtcStreamRequest) (<-chan *HotLiveRtcStreamResponse, <-chan error) {
	responseChan := make(chan *HotLiveRtcStreamResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.HotLiveRtcStream(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// HotLiveRtcStreamWithCallback invokes the live.HotLiveRtcStream API asynchronously
func (client *Client) HotLiveRtcStreamWithCallback(request *HotLiveRtcStreamRequest, callback func(response *HotLiveRtcStreamResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *HotLiveRtcStreamResponse
		var err error
		defer close(result)
		response, err = client.HotLiveRtcStream(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// HotLiveRtcStreamRequest is the request struct for api HotLiveRtcStream
type HotLiveRtcStreamRequest struct {
	*requests.RpcRequest
	VideoMsid         string           `position:"Query" name:"VideoMsid"`
	RegionCode        string           `position:"Query" name:"RegionCode"`
	ConnectionTimeout string           `position:"Query" name:"ConnectionTimeout"`
	AppName           string           `position:"Query" name:"AppName"`
	AudioMsid         string           `position:"Query" name:"AudioMsid"`
	MediaTimeout      string           `position:"Query" name:"MediaTimeout"`
	StreamName        string           `position:"Query" name:"StreamName"`
	DomainName        string           `position:"Query" name:"DomainName"`
	OwnerId           requests.Integer `position:"Query" name:"OwnerId"`
}

// HotLiveRtcStreamResponse is the response struct for api HotLiveRtcStream
type HotLiveRtcStreamResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateHotLiveRtcStreamRequest creates a request to invoke HotLiveRtcStream API
func CreateHotLiveRtcStreamRequest() (request *HotLiveRtcStreamRequest) {
	request = &HotLiveRtcStreamRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "HotLiveRtcStream", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateHotLiveRtcStreamResponse creates a response to parse from HotLiveRtcStream response
func CreateHotLiveRtcStreamResponse() (response *HotLiveRtcStreamResponse) {
	response = &HotLiveRtcStreamResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
