package ltl

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UnLockMember invokes the ltl.UnLockMember API synchronously
func (client *Client) UnLockMember(request *UnLockMemberRequest) (response *UnLockMemberResponse, err error) {
	response = CreateUnLockMemberResponse()
	err = client.DoAction(request, response)
	return
}

// UnLockMemberWithChan invokes the ltl.UnLockMember API asynchronously
func (client *Client) UnLockMemberWithChan(request *UnLockMemberRequest) (<-chan *UnLockMemberResponse, <-chan error) {
	responseChan := make(chan *UnLockMemberResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UnLockMember(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UnLockMemberWithCallback invokes the ltl.UnLockMember API asynchronously
func (client *Client) UnLockMemberWithCallback(request *UnLockMemberRequest, callback func(response *UnLockMemberResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UnLockMemberResponse
		var err error
		defer close(result)
		response, err = client.UnLockMember(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UnLockMemberRequest is the request struct for api UnLockMember
type UnLockMemberRequest struct {
	*requests.RpcRequest
	ApiVersion string `position:"Query" name:"ApiVersion"`
	BizChainId string `position:"Query" name:"BizChainId"`
	MemberId   string `position:"Query" name:"MemberId"`
}

// UnLockMemberResponse is the response struct for api UnLockMember
type UnLockMemberResponse struct {
	*responses.BaseResponse
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateUnLockMemberRequest creates a request to invoke UnLockMember API
func CreateUnLockMemberRequest() (request *UnLockMemberRequest) {
	request = &UnLockMemberRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ltl", "2019-05-10", "UnLockMember", "", "")
	request.Method = requests.POST
	return
}

// CreateUnLockMemberResponse creates a response to parse from UnLockMember response
func CreateUnLockMemberResponse() (response *UnLockMemberResponse) {
	response = &UnLockMemberResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
