package lto

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DownloadPrivacyKey invokes the lto.DownloadPrivacyKey API synchronously
func (client *Client) DownloadPrivacyKey(request *DownloadPrivacyKeyRequest) (response *DownloadPrivacyKeyResponse, err error) {
	response = CreateDownloadPrivacyKeyResponse()
	err = client.DoAction(request, response)
	return
}

// DownloadPrivacyKeyWithChan invokes the lto.DownloadPrivacyKey API asynchronously
func (client *Client) DownloadPrivacyKeyWithChan(request *DownloadPrivacyKeyRequest) (<-chan *DownloadPrivacyKeyResponse, <-chan error) {
	responseChan := make(chan *DownloadPrivacyKeyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DownloadPrivacyKey(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DownloadPrivacyKeyWithCallback invokes the lto.DownloadPrivacyKey API asynchronously
func (client *Client) DownloadPrivacyKeyWithCallback(request *DownloadPrivacyKeyRequest, callback func(response *DownloadPrivacyKeyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DownloadPrivacyKeyResponse
		var err error
		defer close(result)
		response, err = client.DownloadPrivacyKey(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DownloadPrivacyKeyRequest is the request struct for api DownloadPrivacyKey
type DownloadPrivacyKeyRequest struct {
	*requests.RpcRequest
}

// DownloadPrivacyKeyResponse is the response struct for api DownloadPrivacyKey
type DownloadPrivacyKeyResponse struct {
	*responses.BaseResponse
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Data           string `json:"Data" xml:"Data"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
}

// CreateDownloadPrivacyKeyRequest creates a request to invoke DownloadPrivacyKey API
func CreateDownloadPrivacyKeyRequest() (request *DownloadPrivacyKeyRequest) {
	request = &DownloadPrivacyKeyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("lto", "2021-07-07", "DownloadPrivacyKey", "", "")
	request.Method = requests.POST
	return
}

// CreateDownloadPrivacyKeyResponse creates a response to parse from DownloadPrivacyKey response
func CreateDownloadPrivacyKeyResponse() (response *DownloadPrivacyKeyResponse) {
	response = &DownloadPrivacyKeyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
