package lto

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListMemberAuthorizedBizChain invokes the lto.ListMemberAuthorizedBizChain API synchronously
func (client *Client) ListMemberAuthorizedBizChain(request *ListMemberAuthorizedBizChainRequest) (response *ListMemberAuthorizedBizChainResponse, err error) {
	response = CreateListMemberAuthorizedBizChainResponse()
	err = client.DoAction(request, response)
	return
}

// ListMemberAuthorizedBizChainWithChan invokes the lto.ListMemberAuthorizedBizChain API asynchronously
func (client *Client) ListMemberAuthorizedBizChainWithChan(request *ListMemberAuthorizedBizChainRequest) (<-chan *ListMemberAuthorizedBizChainResponse, <-chan error) {
	responseChan := make(chan *ListMemberAuthorizedBizChainResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListMemberAuthorizedBizChain(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListMemberAuthorizedBizChainWithCallback invokes the lto.ListMemberAuthorizedBizChain API asynchronously
func (client *Client) ListMemberAuthorizedBizChainWithCallback(request *ListMemberAuthorizedBizChainRequest, callback func(response *ListMemberAuthorizedBizChainResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListMemberAuthorizedBizChainResponse
		var err error
		defer close(result)
		response, err = client.ListMemberAuthorizedBizChain(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListMemberAuthorizedBizChainRequest is the request struct for api ListMemberAuthorizedBizChain
type ListMemberAuthorizedBizChainRequest struct {
	*requests.RpcRequest
	MemberId string `position:"Query" name:"MemberId"`
}

// ListMemberAuthorizedBizChainResponse is the response struct for api ListMemberAuthorizedBizChain
type ListMemberAuthorizedBizChainResponse struct {
	*responses.BaseResponse
	Code           string                         `json:"Code" xml:"Code"`
	HttpStatusCode int                            `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string                         `json:"Message" xml:"Message"`
	RequestId      string                         `json:"RequestId" xml:"RequestId"`
	Success        bool                           `json:"Success" xml:"Success"`
	Data           []MemberAuthorizedBizChainInfo `json:"Data" xml:"Data"`
}

// CreateListMemberAuthorizedBizChainRequest creates a request to invoke ListMemberAuthorizedBizChain API
func CreateListMemberAuthorizedBizChainRequest() (request *ListMemberAuthorizedBizChainRequest) {
	request = &ListMemberAuthorizedBizChainRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("lto", "2021-07-07", "ListMemberAuthorizedBizChain", "", "")
	request.Method = requests.POST
	return
}

// CreateListMemberAuthorizedBizChainResponse creates a response to parse from ListMemberAuthorizedBizChain response
func CreateListMemberAuthorizedBizChainResponse() (response *ListMemberAuthorizedBizChainResponse) {
	response = &ListMemberAuthorizedBizChainResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
