package market

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeCurrentNodeInfo invokes the market.DescribeCurrentNodeInfo API synchronously
func (client *Client) DescribeCurrentNodeInfo(request *DescribeCurrentNodeInfoRequest) (response *DescribeCurrentNodeInfoResponse, err error) {
	response = CreateDescribeCurrentNodeInfoResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeCurrentNodeInfoWithChan invokes the market.DescribeCurrentNodeInfo API asynchronously
func (client *Client) DescribeCurrentNodeInfoWithChan(request *DescribeCurrentNodeInfoRequest) (<-chan *DescribeCurrentNodeInfoResponse, <-chan error) {
	responseChan := make(chan *DescribeCurrentNodeInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeCurrentNodeInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeCurrentNodeInfoWithCallback invokes the market.DescribeCurrentNodeInfo API asynchronously
func (client *Client) DescribeCurrentNodeInfoWithCallback(request *DescribeCurrentNodeInfoRequest, callback func(response *DescribeCurrentNodeInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeCurrentNodeInfoResponse
		var err error
		defer close(result)
		response, err = client.DescribeCurrentNodeInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeCurrentNodeInfoRequest is the request struct for api DescribeCurrentNodeInfo
type DescribeCurrentNodeInfoRequest struct {
	*requests.RpcRequest
	InstanceId string `position:"Query" name:"InstanceId"`
}

// DescribeCurrentNodeInfoResponse is the response struct for api DescribeCurrentNodeInfo
type DescribeCurrentNodeInfoResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"Success" xml:"Success"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    Result `json:"Result" xml:"Result"`
}

// CreateDescribeCurrentNodeInfoRequest creates a request to invoke DescribeCurrentNodeInfo API
func CreateDescribeCurrentNodeInfoRequest() (request *DescribeCurrentNodeInfoRequest) {
	request = &DescribeCurrentNodeInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Market", "2015-11-01", "DescribeCurrentNodeInfo", "yunmarket", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeCurrentNodeInfoResponse creates a response to parse from DescribeCurrentNodeInfo response
func CreateDescribeCurrentNodeInfoResponse() (response *DescribeCurrentNodeInfoResponse) {
	response = &DescribeCurrentNodeInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
