package mpaas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateMcubeUpgradeTask invokes the mpaas.CreateMcubeUpgradeTask API synchronously
func (client *Client) CreateMcubeUpgradeTask(request *CreateMcubeUpgradeTaskRequest) (response *CreateMcubeUpgradeTaskResponse, err error) {
	response = CreateCreateMcubeUpgradeTaskResponse()
	err = client.DoAction(request, response)
	return
}

// CreateMcubeUpgradeTaskWithChan invokes the mpaas.CreateMcubeUpgradeTask API asynchronously
func (client *Client) CreateMcubeUpgradeTaskWithChan(request *CreateMcubeUpgradeTaskRequest) (<-chan *CreateMcubeUpgradeTaskResponse, <-chan error) {
	responseChan := make(chan *CreateMcubeUpgradeTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateMcubeUpgradeTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateMcubeUpgradeTaskWithCallback invokes the mpaas.CreateMcubeUpgradeTask API asynchronously
func (client *Client) CreateMcubeUpgradeTaskWithCallback(request *CreateMcubeUpgradeTaskRequest, callback func(response *CreateMcubeUpgradeTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateMcubeUpgradeTaskResponse
		var err error
		defer close(result)
		response, err = client.CreateMcubeUpgradeTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateMcubeUpgradeTaskRequest is the request struct for api CreateMcubeUpgradeTask
type CreateMcubeUpgradeTaskRequest struct {
	*requests.RpcRequest
	PackageInfoId   requests.Integer `position:"Body" name:"PackageInfoId"`
	UpgradeContent  string           `position:"Body" name:"UpgradeContent"`
	Memo            string           `position:"Body" name:"Memo"`
	UpgradeType     requests.Integer `position:"Body" name:"UpgradeType"`
	GreyConfigInfo  string           `position:"Body" name:"GreyConfigInfo"`
	TenantId        string           `position:"Body" name:"TenantId"`
	PublishMode     requests.Integer `position:"Body" name:"PublishMode"`
	WhitelistIds    string           `position:"Body" name:"WhitelistIds"`
	PublishType     requests.Integer `position:"Body" name:"PublishType"`
	GreyNum         requests.Integer `position:"Body" name:"GreyNum"`
	AppId           string           `position:"Body" name:"AppId"`
	HistoryForce    requests.Integer `position:"Body" name:"HistoryForce"`
	GreyEndtimeData string           `position:"Body" name:"GreyEndtimeData"`
	WorkspaceId     string           `position:"Body" name:"WorkspaceId"`
}

// CreateMcubeUpgradeTaskResponse is the response struct for api CreateMcubeUpgradeTask
type CreateMcubeUpgradeTaskResponse struct {
	*responses.BaseResponse
	ResultMessage    string           `json:"ResultMessage" xml:"ResultMessage"`
	ResultCode       string           `json:"ResultCode" xml:"ResultCode"`
	RequestId        string           `json:"RequestId" xml:"RequestId"`
	CreateTaskResult CreateTaskResult `json:"CreateTaskResult" xml:"CreateTaskResult"`
}

// CreateCreateMcubeUpgradeTaskRequest creates a request to invoke CreateMcubeUpgradeTask API
func CreateCreateMcubeUpgradeTaskRequest() (request *CreateMcubeUpgradeTaskRequest) {
	request = &CreateMcubeUpgradeTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mPaaS", "2020-10-28", "CreateMcubeUpgradeTask", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateMcubeUpgradeTaskResponse creates a response to parse from CreateMcubeUpgradeTask response
func CreateCreateMcubeUpgradeTaskResponse() (response *CreateMcubeUpgradeTaskResponse) {
	response = &CreateMcubeUpgradeTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
