package mse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateGatewayAuthConsumerResource invokes the mse.UpdateGatewayAuthConsumerResource API synchronously
func (client *Client) UpdateGatewayAuthConsumerResource(request *UpdateGatewayAuthConsumerResourceRequest) (response *UpdateGatewayAuthConsumerResourceResponse, err error) {
	response = CreateUpdateGatewayAuthConsumerResourceResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateGatewayAuthConsumerResourceWithChan invokes the mse.UpdateGatewayAuthConsumerResource API asynchronously
func (client *Client) UpdateGatewayAuthConsumerResourceWithChan(request *UpdateGatewayAuthConsumerResourceRequest) (<-chan *UpdateGatewayAuthConsumerResourceResponse, <-chan error) {
	responseChan := make(chan *UpdateGatewayAuthConsumerResourceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateGatewayAuthConsumerResource(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateGatewayAuthConsumerResourceWithCallback invokes the mse.UpdateGatewayAuthConsumerResource API asynchronously
func (client *Client) UpdateGatewayAuthConsumerResourceWithCallback(request *UpdateGatewayAuthConsumerResourceRequest, callback func(response *UpdateGatewayAuthConsumerResourceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateGatewayAuthConsumerResourceResponse
		var err error
		defer close(result)
		response, err = client.UpdateGatewayAuthConsumerResource(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateGatewayAuthConsumerResourceRequest is the request struct for api UpdateGatewayAuthConsumerResource
type UpdateGatewayAuthConsumerResourceRequest struct {
	*requests.RpcRequest
	MseSessionId    string           `position:"Query" name:"MseSessionId"`
	GatewayUniqueId string           `position:"Query" name:"GatewayUniqueId"`
	ConsumerId      requests.Integer `position:"Query" name:"ConsumerId"`
	ResourceList    string           `position:"Query" name:"ResourceList"`
	AcceptLanguage  string           `position:"Query" name:"AcceptLanguage"`
}

// UpdateGatewayAuthConsumerResourceResponse is the response struct for api UpdateGatewayAuthConsumerResource
type UpdateGatewayAuthConsumerResourceResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           int    `json:"Code" xml:"Code"`
	ErrorCode      string `json:"ErrorCode" xml:"ErrorCode"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string `json:"Message" xml:"Message"`
	DynamicCode    string `json:"DynamicCode" xml:"DynamicCode"`
	DynamicMessage string `json:"DynamicMessage" xml:"DynamicMessage"`
	Data           bool   `json:"Data" xml:"Data"`
}

// CreateUpdateGatewayAuthConsumerResourceRequest creates a request to invoke UpdateGatewayAuthConsumerResource API
func CreateUpdateGatewayAuthConsumerResourceRequest() (request *UpdateGatewayAuthConsumerResourceRequest) {
	request = &UpdateGatewayAuthConsumerResourceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mse", "2019-05-31", "UpdateGatewayAuthConsumerResource", "mse", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateGatewayAuthConsumerResourceResponse creates a response to parse from UpdateGatewayAuthConsumerResource response
func CreateUpdateGatewayAuthConsumerResourceResponse() (response *UpdateGatewayAuthConsumerResourceResponse) {
	response = &UpdateGatewayAuthConsumerResourceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
