package mseap

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GenerateUploadFilePolicyForPartner invokes the mseap.GenerateUploadFilePolicyForPartner API synchronously
func (client *Client) GenerateUploadFilePolicyForPartner(request *GenerateUploadFilePolicyForPartnerRequest) (response *GenerateUploadFilePolicyForPartnerResponse, err error) {
	response = CreateGenerateUploadFilePolicyForPartnerResponse()
	err = client.DoAction(request, response)
	return
}

// GenerateUploadFilePolicyForPartnerWithChan invokes the mseap.GenerateUploadFilePolicyForPartner API asynchronously
func (client *Client) GenerateUploadFilePolicyForPartnerWithChan(request *GenerateUploadFilePolicyForPartnerRequest) (<-chan *GenerateUploadFilePolicyForPartnerResponse, <-chan error) {
	responseChan := make(chan *GenerateUploadFilePolicyForPartnerResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GenerateUploadFilePolicyForPartner(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GenerateUploadFilePolicyForPartnerWithCallback invokes the mseap.GenerateUploadFilePolicyForPartner API asynchronously
func (client *Client) GenerateUploadFilePolicyForPartnerWithCallback(request *GenerateUploadFilePolicyForPartnerRequest, callback func(response *GenerateUploadFilePolicyForPartnerResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GenerateUploadFilePolicyForPartnerResponse
		var err error
		defer close(result)
		response, err = client.GenerateUploadFilePolicyForPartner(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GenerateUploadFilePolicyForPartnerRequest is the request struct for api GenerateUploadFilePolicyForPartner
type GenerateUploadFilePolicyForPartnerRequest struct {
	*requests.RpcRequest
	FileType string `position:"Query" name:"FileType"`
	BizType  string `position:"Query" name:"BizType"`
	FileName string `position:"Query" name:"FileName"`
}

// GenerateUploadFilePolicyForPartnerResponse is the response struct for api GenerateUploadFilePolicyForPartner
type GenerateUploadFilePolicyForPartnerResponse struct {
	*responses.BaseResponse
	RequestId      string   `json:"RequestId" xml:"RequestId"`
	HttpStatusCode int      `json:"HttpStatusCode" xml:"HttpStatusCode"`
	DynamicCode    string   `json:"DynamicCode" xml:"DynamicCode"`
	DynamicMessage string   `json:"DynamicMessage" xml:"DynamicMessage"`
	ErrorMsg       string   `json:"ErrorMsg" xml:"ErrorMsg"`
	ErrorCode      string   `json:"ErrorCode" xml:"ErrorCode"`
	Success        bool     `json:"Success" xml:"Success"`
	AllowRetry     bool     `json:"AllowRetry" xml:"AllowRetry"`
	AppName        string   `json:"AppName" xml:"AppName"`
	ErrorArgs      []string `json:"ErrorArgs" xml:"ErrorArgs"`
	Module         Module   `json:"Module" xml:"Module"`
}

// CreateGenerateUploadFilePolicyForPartnerRequest creates a request to invoke GenerateUploadFilePolicyForPartner API
func CreateGenerateUploadFilePolicyForPartnerRequest() (request *GenerateUploadFilePolicyForPartnerRequest) {
	request = &GenerateUploadFilePolicyForPartnerRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mseap", "2021-01-18", "GenerateUploadFilePolicyForPartner", "", "")
	request.Method = requests.POST
	return
}

// CreateGenerateUploadFilePolicyForPartnerResponse creates a response to parse from GenerateUploadFilePolicyForPartner response
func CreateGenerateUploadFilePolicyForPartnerResponse() (response *GenerateUploadFilePolicyForPartnerResponse) {
	response = &GenerateUploadFilePolicyForPartnerResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
