package nas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteLDAPConfig invokes the nas.DeleteLDAPConfig API synchronously
func (client *Client) DeleteLDAPConfig(request *DeleteLDAPConfigRequest) (response *DeleteLDAPConfigResponse, err error) {
	response = CreateDeleteLDAPConfigResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteLDAPConfigWithChan invokes the nas.DeleteLDAPConfig API asynchronously
func (client *Client) DeleteLDAPConfigWithChan(request *DeleteLDAPConfigRequest) (<-chan *DeleteLDAPConfigResponse, <-chan error) {
	responseChan := make(chan *DeleteLDAPConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteLDAPConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteLDAPConfigWithCallback invokes the nas.DeleteLDAPConfig API asynchronously
func (client *Client) DeleteLDAPConfigWithCallback(request *DeleteLDAPConfigRequest, callback func(response *DeleteLDAPConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteLDAPConfigResponse
		var err error
		defer close(result)
		response, err = client.DeleteLDAPConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteLDAPConfigRequest is the request struct for api DeleteLDAPConfig
type DeleteLDAPConfigRequest struct {
	*requests.RpcRequest
	FileSystemId string `position:"Query" name:"FileSystemId"`
}

// DeleteLDAPConfigResponse is the response struct for api DeleteLDAPConfig
type DeleteLDAPConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteLDAPConfigRequest creates a request to invoke DeleteLDAPConfig API
func CreateDeleteLDAPConfigRequest() (request *DeleteLDAPConfigRequest) {
	request = &DeleteLDAPConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("NAS", "2017-06-26", "DeleteLDAPConfig", "nas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteLDAPConfigResponse creates a response to parse from DeleteLDAPConfig response
func CreateDeleteLDAPConfigResponse() (response *DeleteLDAPConfigResponse) {
	response = &DeleteLDAPConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
