package nis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetNisNetworkRanking invokes the nis.GetNisNetworkRanking API synchronously
func (client *Client) GetNisNetworkRanking(request *GetNisNetworkRankingRequest) (response *GetNisNetworkRankingResponse, err error) {
	response = CreateGetNisNetworkRankingResponse()
	err = client.DoAction(request, response)
	return
}

// GetNisNetworkRankingWithChan invokes the nis.GetNisNetworkRanking API asynchronously
func (client *Client) GetNisNetworkRankingWithChan(request *GetNisNetworkRankingRequest) (<-chan *GetNisNetworkRankingResponse, <-chan error) {
	responseChan := make(chan *GetNisNetworkRankingResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetNisNetworkRanking(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetNisNetworkRankingWithCallback invokes the nis.GetNisNetworkRanking API asynchronously
func (client *Client) GetNisNetworkRankingWithCallback(request *GetNisNetworkRankingRequest, callback func(response *GetNisNetworkRankingResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetNisNetworkRankingResponse
		var err error
		defer close(result)
		response, err = client.GetNisNetworkRanking(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetNisNetworkRankingRequest is the request struct for api GetNisNetworkRanking
type GetNisNetworkRankingRequest struct {
	*requests.RpcRequest
	UseCrossAccount requests.Boolean              `position:"Query" name:"UseCrossAccount"`
	TopN            requests.Integer              `position:"Query" name:"TopN"`
	Direction       string                        `position:"Query" name:"Direction"`
	OrderBy         string                        `position:"Query" name:"OrderBy"`
	EndTime         requests.Integer              `position:"Query" name:"EndTime"`
	BeginTime       requests.Integer              `position:"Query" name:"BeginTime"`
	GroupBy         string                        `position:"Query" name:"GroupBy"`
	Sort            string                        `position:"Query" name:"Sort"`
	ResourceType    string                        `position:"Query" name:"ResourceType"`
	RegionNo        string                        `position:"Query" name:"RegionNo"`
	Filter          *[]GetNisNetworkRankingFilter `position:"Query" name:"Filter"  type:"Json"`
	AccountIds      *[]string                     `position:"Query" name:"AccountIds"  type:"Repeated"`
}

// GetNisNetworkRankingFilter is a repeated param struct in GetNisNetworkRankingRequest
type GetNisNetworkRankingFilter struct {
	Name  string `name:"Name"`
	Value string `name:"Value"`
}

// GetNisNetworkRankingResponse is the response struct for api GetNisNetworkRanking
type GetNisNetworkRankingResponse struct {
	*responses.BaseResponse
	RequestId string     `json:"RequestId" xml:"RequestId"`
	Data      []Rankings `json:"Data" xml:"Data"`
}

// CreateGetNisNetworkRankingRequest creates a request to invoke GetNisNetworkRanking API
func CreateGetNisNetworkRankingRequest() (request *GetNisNetworkRankingRequest) {
	request = &GetNisNetworkRankingRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("nis", "2021-12-16", "GetNisNetworkRanking", "networkana", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetNisNetworkRankingResponse creates a response to parse from GetNisNetworkRanking response
func CreateGetNisNetworkRankingResponse() (response *GetNisNetworkRankingResponse) {
	response = &GetNisNetworkRankingResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
