package oam

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteGroupTagMiddle invokes the oam.DeleteGroupTagMiddle API synchronously
// api document: https://help.aliyun.com/api/oam/deletegrouptagmiddle.html
func (client *Client) DeleteGroupTagMiddle(request *DeleteGroupTagMiddleRequest) (response *DeleteGroupTagMiddleResponse, err error) {
	response = CreateDeleteGroupTagMiddleResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteGroupTagMiddleWithChan invokes the oam.DeleteGroupTagMiddle API asynchronously
// api document: https://help.aliyun.com/api/oam/deletegrouptagmiddle.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteGroupTagMiddleWithChan(request *DeleteGroupTagMiddleRequest) (<-chan *DeleteGroupTagMiddleResponse, <-chan error) {
	responseChan := make(chan *DeleteGroupTagMiddleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteGroupTagMiddle(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteGroupTagMiddleWithCallback invokes the oam.DeleteGroupTagMiddle API asynchronously
// api document: https://help.aliyun.com/api/oam/deletegrouptagmiddle.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteGroupTagMiddleWithCallback(request *DeleteGroupTagMiddleRequest, callback func(response *DeleteGroupTagMiddleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteGroupTagMiddleResponse
		var err error
		defer close(result)
		response, err = client.DeleteGroupTagMiddle(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteGroupTagMiddleRequest is the request struct for api DeleteGroupTagMiddle
type DeleteGroupTagMiddleRequest struct {
	*requests.RpcRequest
	TagId      *[]string `position:"Query" name:"TagId"  type:"Repeated"`
	GroupTagId string    `position:"Query" name:"GroupTagId"`
}

// DeleteGroupTagMiddleResponse is the response struct for api DeleteGroupTagMiddle
type DeleteGroupTagMiddleResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteGroupTagMiddleRequest creates a request to invoke DeleteGroupTagMiddle API
func CreateDeleteGroupTagMiddleRequest() (request *DeleteGroupTagMiddleRequest) {
	request = &DeleteGroupTagMiddleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Oam", "2017-01-01", "DeleteGroupTagMiddle", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteGroupTagMiddleResponse creates a response to parse from DeleteGroupTagMiddle response
func CreateDeleteGroupTagMiddleResponse() (response *DeleteGroupTagMiddleResponse) {
	response = &DeleteGroupTagMiddleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
