package oceanbasepro

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeNodeMetrics invokes the oceanbasepro.DescribeNodeMetrics API synchronously
func (client *Client) DescribeNodeMetrics(request *DescribeNodeMetricsRequest) (response *DescribeNodeMetricsResponse, err error) {
	response = CreateDescribeNodeMetricsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeNodeMetricsWithChan invokes the oceanbasepro.DescribeNodeMetrics API asynchronously
func (client *Client) DescribeNodeMetricsWithChan(request *DescribeNodeMetricsRequest) (<-chan *DescribeNodeMetricsResponse, <-chan error) {
	responseChan := make(chan *DescribeNodeMetricsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeNodeMetrics(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeNodeMetricsWithCallback invokes the oceanbasepro.DescribeNodeMetrics API asynchronously
func (client *Client) DescribeNodeMetricsWithCallback(request *DescribeNodeMetricsRequest, callback func(response *DescribeNodeMetricsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeNodeMetricsResponse
		var err error
		defer close(result)
		response, err = client.DescribeNodeMetrics(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeNodeMetricsRequest is the request struct for api DescribeNodeMetrics
type DescribeNodeMetricsRequest struct {
	*requests.RpcRequest
	StartTime  string           `position:"Body" name:"StartTime"`
	PageNumber requests.Integer `position:"Body" name:"PageNumber"`
	PageSize   requests.Integer `position:"Body" name:"PageSize"`
	TenantId   string           `position:"Body" name:"TenantId"`
	NodeIdList string           `position:"Body" name:"NodeIdList"`
	EndTime    string           `position:"Body" name:"EndTime"`
	NodeName   string           `position:"Body" name:"NodeName"`
	InstanceId string           `position:"Body" name:"InstanceId"`
	Metrics    string           `position:"Body" name:"Metrics"`
}

// DescribeNodeMetricsResponse is the response struct for api DescribeNodeMetrics
type DescribeNodeMetricsResponse struct {
	*responses.BaseResponse
	TotalCount  int    `json:"TotalCount" xml:"TotalCount"`
	RequestId   string `json:"RequestId" xml:"RequestId"`
	NodeMetrics string `json:"NodeMetrics" xml:"NodeMetrics"`
}

// CreateDescribeNodeMetricsRequest creates a request to invoke DescribeNodeMetrics API
func CreateDescribeNodeMetricsRequest() (request *DescribeNodeMetricsRequest) {
	request = &DescribeNodeMetricsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OceanBasePro", "2019-09-01", "DescribeNodeMetrics", "oceanbase", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeNodeMetricsResponse creates a response to parse from DescribeNodeMetrics response
func CreateDescribeNodeMetricsResponse() (response *DescribeNodeMetricsResponse) {
	response = &DescribeNodeMetricsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
