package oceanbasepro

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyTenantPrimaryZone invokes the oceanbasepro.ModifyTenantPrimaryZone API synchronously
func (client *Client) ModifyTenantPrimaryZone(request *ModifyTenantPrimaryZoneRequest) (response *ModifyTenantPrimaryZoneResponse, err error) {
	response = CreateModifyTenantPrimaryZoneResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyTenantPrimaryZoneWithChan invokes the oceanbasepro.ModifyTenantPrimaryZone API asynchronously
func (client *Client) ModifyTenantPrimaryZoneWithChan(request *ModifyTenantPrimaryZoneRequest) (<-chan *ModifyTenantPrimaryZoneResponse, <-chan error) {
	responseChan := make(chan *ModifyTenantPrimaryZoneResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyTenantPrimaryZone(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyTenantPrimaryZoneWithCallback invokes the oceanbasepro.ModifyTenantPrimaryZone API asynchronously
func (client *Client) ModifyTenantPrimaryZoneWithCallback(request *ModifyTenantPrimaryZoneRequest, callback func(response *ModifyTenantPrimaryZoneResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyTenantPrimaryZoneResponse
		var err error
		defer close(result)
		response, err = client.ModifyTenantPrimaryZone(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyTenantPrimaryZoneRequest is the request struct for api ModifyTenantPrimaryZone
type ModifyTenantPrimaryZoneRequest struct {
	*requests.RpcRequest
	TenantEndpointDirectId    string `position:"Body" name:"TenantEndpointDirectId"`
	UserVSwitchId             string `position:"Body" name:"UserVSwitchId"`
	MasterIntranetAddressZone string `position:"Body" name:"MasterIntranetAddressZone"`
	TenantId                  string `position:"Body" name:"TenantId"`
	TenantEndpointId          string `position:"Body" name:"TenantEndpointId"`
	InstanceId                string `position:"Body" name:"InstanceId"`
	PrimaryZone               string `position:"Body" name:"PrimaryZone"`
	VpcId                     string `position:"Body" name:"VpcId"`
	UserVpcOwnerId            string `position:"Body" name:"UserVpcOwnerId"`
	UserDirectVSwitchId       string `position:"Body" name:"UserDirectVSwitchId"`
}

// ModifyTenantPrimaryZoneResponse is the response struct for api ModifyTenantPrimaryZone
type ModifyTenantPrimaryZoneResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyTenantPrimaryZoneRequest creates a request to invoke ModifyTenantPrimaryZone API
func CreateModifyTenantPrimaryZoneRequest() (request *ModifyTenantPrimaryZoneRequest) {
	request = &ModifyTenantPrimaryZoneRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OceanBasePro", "2019-09-01", "ModifyTenantPrimaryZone", "oceanbase", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyTenantPrimaryZoneResponse creates a response to parse from ModifyTenantPrimaryZone response
func CreateModifyTenantPrimaryZoneResponse() (response *ModifyTenantPrimaryZoneResponse) {
	response = &ModifyTenantPrimaryZoneResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
