package oms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// PutReadyFlagByProxy invokes the oms.PutReadyFlagByProxy API synchronously
func (client *Client) PutReadyFlagByProxy(request *PutReadyFlagByProxyRequest) (response *PutReadyFlagByProxyResponse, err error) {
	response = CreatePutReadyFlagByProxyResponse()
	err = client.DoAction(request, response)
	return
}

// PutReadyFlagByProxyWithChan invokes the oms.PutReadyFlagByProxy API asynchronously
func (client *Client) PutReadyFlagByProxyWithChan(request *PutReadyFlagByProxyRequest) (<-chan *PutReadyFlagByProxyResponse, <-chan error) {
	responseChan := make(chan *PutReadyFlagByProxyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.PutReadyFlagByProxy(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// PutReadyFlagByProxyWithCallback invokes the oms.PutReadyFlagByProxy API asynchronously
func (client *Client) PutReadyFlagByProxyWithCallback(request *PutReadyFlagByProxyRequest, callback func(response *PutReadyFlagByProxyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *PutReadyFlagByProxyResponse
		var err error
		defer close(result)
		response, err = client.PutReadyFlagByProxy(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// PutReadyFlagByProxyRequest is the request struct for api PutReadyFlagByProxy
type PutReadyFlagByProxyRequest struct {
	*requests.RpcRequest
	DomainCode string           `position:"Query" name:"DomainCode"`
	Data       string           `position:"Query" name:"Data"`
	DataType   string           `position:"Query" name:"DataType"`
	Compressed requests.Boolean `position:"Query" name:"Compressed"`
	ApiType    string           `position:"Query" name:"ApiType"`
}

// PutReadyFlagByProxyResponse is the response struct for api PutReadyFlagByProxy
type PutReadyFlagByProxyResponse struct {
	*responses.BaseResponse
	DataType   string `json:"DataType" xml:"DataType"`
	RequestId  string `json:"RequestId" xml:"RequestId"`
	DomainCode string `json:"DomainCode" xml:"DomainCode"`
	ApiType    string `json:"ApiType" xml:"ApiType"`
}

// CreatePutReadyFlagByProxyRequest creates a request to invoke PutReadyFlagByProxy API
func CreatePutReadyFlagByProxyRequest() (request *PutReadyFlagByProxyRequest) {
	request = &PutReadyFlagByProxyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Oms", "2016-06-15", "PutReadyFlagByProxy", "", "")
	request.Method = requests.POST
	return
}

// CreatePutReadyFlagByProxyResponse creates a response to parse from PutReadyFlagByProxy response
func CreatePutReadyFlagByProxyResponse() (response *PutReadyFlagByProxyResponse) {
	response = &PutReadyFlagByProxyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
