package opensearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BindEsInstance invokes the opensearch.BindEsInstance API synchronously
func (client *Client) BindEsInstance(request *BindEsInstanceRequest) (response *BindEsInstanceResponse, err error) {
	response = CreateBindEsInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// BindEsInstanceWithChan invokes the opensearch.BindEsInstance API asynchronously
func (client *Client) BindEsInstanceWithChan(request *BindEsInstanceRequest) (<-chan *BindEsInstanceResponse, <-chan error) {
	responseChan := make(chan *BindEsInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BindEsInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BindEsInstanceWithCallback invokes the opensearch.BindEsInstance API asynchronously
func (client *Client) BindEsInstanceWithCallback(request *BindEsInstanceRequest, callback func(response *BindEsInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BindEsInstanceResponse
		var err error
		defer close(result)
		response, err = client.BindEsInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BindEsInstanceRequest is the request struct for api BindEsInstance
type BindEsInstanceRequest struct {
	*requests.RoaRequest
	AppGroupIdentity string `position:"Path" name:"appGroupIdentity"`
}

// BindEsInstanceResponse is the response struct for api BindEsInstance
type BindEsInstanceResponse struct {
	*responses.BaseResponse
	Result    map[string]interface{} `json:"result" xml:"result"`
	RequestId string                 `json:"requestId" xml:"requestId"`
}

// CreateBindEsInstanceRequest creates a request to invoke BindEsInstance API
func CreateBindEsInstanceRequest() (request *BindEsInstanceRequest) {
	request = &BindEsInstanceRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("OpenSearch", "2017-12-25", "BindEsInstance", "/v4/openapi/app-groups/[appGroupIdentity]/actions/bind-es-instance", "", "")
	request.Method = requests.POST
	return
}

// CreateBindEsInstanceResponse creates a response to parse from BindEsInstance response
func CreateBindEsInstanceResponse() (response *BindEsInstanceResponse) {
	response = &BindEsInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
