package paielasticdatasetaccelerator

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeComponent invokes the paielasticdatasetaccelerator.DescribeComponent API synchronously
func (client *Client) DescribeComponent(request *DescribeComponentRequest) (response *DescribeComponentResponse, err error) {
	response = CreateDescribeComponentResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeComponentWithChan invokes the paielasticdatasetaccelerator.DescribeComponent API asynchronously
func (client *Client) DescribeComponentWithChan(request *DescribeComponentRequest) (<-chan *DescribeComponentResponse, <-chan error) {
	responseChan := make(chan *DescribeComponentResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeComponent(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeComponentWithCallback invokes the paielasticdatasetaccelerator.DescribeComponent API asynchronously
func (client *Client) DescribeComponentWithCallback(request *DescribeComponentRequest, callback func(response *DescribeComponentResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeComponentResponse
		var err error
		defer close(result)
		response, err = client.DescribeComponent(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeComponentRequest is the request struct for api DescribeComponent
type DescribeComponentRequest struct {
	*requests.RoaRequest
	ComponentId    string           `position:"Path" name:"ComponentId"`
	Values         string           `position:"Query" name:"Values"`
	RenderTemplate requests.Boolean `position:"Query" name:"RenderTemplate"`
}

// DescribeComponentResponse is the response struct for api DescribeComponent
type DescribeComponentResponse struct {
	*responses.BaseResponse
	RequestId       string   `json:"RequestId" xml:"RequestId"`
	UserId          string   `json:"UserId" xml:"UserId"`
	OwnerId         string   `json:"OwnerId" xml:"OwnerId"`
	GmtCreateTime   string   `json:"GmtCreateTime" xml:"GmtCreateTime"`
	GmtModifiedTime string   `json:"GmtModifiedTime" xml:"GmtModifiedTime"`
	Uuid            string   `json:"Uuid" xml:"Uuid"`
	Name            string   `json:"Name" xml:"Name"`
	Version         string   `json:"Version" xml:"Version"`
	RenderedContent string   `json:"RenderedContent" xml:"RenderedContent"`
	Template        Template `json:"Template" xml:"Template"`
}

// CreateDescribeComponentRequest creates a request to invoke DescribeComponent API
func CreateDescribeComponentRequest() (request *DescribeComponentRequest) {
	request = &DescribeComponentRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("PAIElasticDatasetAccelerator", "2022-08-01", "DescribeComponent", "/api/v1/components/[ComponentId]", "datasetacc", "openAPI")
	request.Method = requests.GET
	return
}

// CreateDescribeComponentResponse creates a response to parse from DescribeComponent response
func CreateDescribeComponentResponse() (response *DescribeComponentResponse) {
	response = &DescribeComponentResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
