package pairecservice

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListFeatureConsistencyCheckJobScoreReports invokes the pairecservice.ListFeatureConsistencyCheckJobScoreReports API synchronously
func (client *Client) ListFeatureConsistencyCheckJobScoreReports(request *ListFeatureConsistencyCheckJobScoreReportsRequest) (response *ListFeatureConsistencyCheckJobScoreReportsResponse, err error) {
	response = CreateListFeatureConsistencyCheckJobScoreReportsResponse()
	err = client.DoAction(request, response)
	return
}

// ListFeatureConsistencyCheckJobScoreReportsWithChan invokes the pairecservice.ListFeatureConsistencyCheckJobScoreReports API asynchronously
func (client *Client) ListFeatureConsistencyCheckJobScoreReportsWithChan(request *ListFeatureConsistencyCheckJobScoreReportsRequest) (<-chan *ListFeatureConsistencyCheckJobScoreReportsResponse, <-chan error) {
	responseChan := make(chan *ListFeatureConsistencyCheckJobScoreReportsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListFeatureConsistencyCheckJobScoreReports(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListFeatureConsistencyCheckJobScoreReportsWithCallback invokes the pairecservice.ListFeatureConsistencyCheckJobScoreReports API asynchronously
func (client *Client) ListFeatureConsistencyCheckJobScoreReportsWithCallback(request *ListFeatureConsistencyCheckJobScoreReportsRequest, callback func(response *ListFeatureConsistencyCheckJobScoreReportsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListFeatureConsistencyCheckJobScoreReportsResponse
		var err error
		defer close(result)
		response, err = client.ListFeatureConsistencyCheckJobScoreReports(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListFeatureConsistencyCheckJobScoreReportsRequest is the request struct for api ListFeatureConsistencyCheckJobScoreReports
type ListFeatureConsistencyCheckJobScoreReportsRequest struct {
	*requests.RoaRequest
	ExcludeRequestIds            string `position:"Query" name:"ExcludeRequestIds"`
	InstanceId                   string `position:"Query" name:"InstanceId"`
	FeatureConsistencyCheckJobId string `position:"Path" name:"FeatureConsistencyCheckJobId"`
}

// ListFeatureConsistencyCheckJobScoreReportsResponse is the response struct for api ListFeatureConsistencyCheckJobScoreReports
type ListFeatureConsistencyCheckJobScoreReportsResponse struct {
	*responses.BaseResponse
	RequestId          string                   `json:"RequestId" xml:"RequestId"`
	DataPath           string                   `json:"DataPath" xml:"DataPath"`
	OssPath            string                   `json:"OssPath" xml:"OssPath"`
	ReportsOfScoreDiff []ReportsOfScoreDiffItem `json:"ReportsOfScoreDiff" xml:"ReportsOfScoreDiff"`
}

// CreateListFeatureConsistencyCheckJobScoreReportsRequest creates a request to invoke ListFeatureConsistencyCheckJobScoreReports API
func CreateListFeatureConsistencyCheckJobScoreReportsRequest() (request *ListFeatureConsistencyCheckJobScoreReportsRequest) {
	request = &ListFeatureConsistencyCheckJobScoreReportsRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("PaiRecService", "2022-12-13", "ListFeatureConsistencyCheckJobScoreReports", "/api/v1/featureconsistencycheck/jobs/[FeatureConsistencyCheckJobId]/scorereports", "", "")
	request.Method = requests.GET
	return
}

// CreateListFeatureConsistencyCheckJobScoreReportsResponse creates a response to parse from ListFeatureConsistencyCheckJobScoreReports response
func CreateListFeatureConsistencyCheckJobScoreReportsResponse() (response *ListFeatureConsistencyCheckJobScoreReportsResponse) {
	response = &ListFeatureConsistencyCheckJobScoreReportsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
