package polardb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateOrGetVirtualLicenseOrder invokes the polardb.CreateOrGetVirtualLicenseOrder API synchronously
func (client *Client) CreateOrGetVirtualLicenseOrder(request *CreateOrGetVirtualLicenseOrderRequest) (response *CreateOrGetVirtualLicenseOrderResponse, err error) {
	response = CreateCreateOrGetVirtualLicenseOrderResponse()
	err = client.DoAction(request, response)
	return
}

// CreateOrGetVirtualLicenseOrderWithChan invokes the polardb.CreateOrGetVirtualLicenseOrder API asynchronously
func (client *Client) CreateOrGetVirtualLicenseOrderWithChan(request *CreateOrGetVirtualLicenseOrderRequest) (<-chan *CreateOrGetVirtualLicenseOrderResponse, <-chan error) {
	responseChan := make(chan *CreateOrGetVirtualLicenseOrderResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateOrGetVirtualLicenseOrder(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateOrGetVirtualLicenseOrderWithCallback invokes the polardb.CreateOrGetVirtualLicenseOrder API asynchronously
func (client *Client) CreateOrGetVirtualLicenseOrderWithCallback(request *CreateOrGetVirtualLicenseOrderRequest, callback func(response *CreateOrGetVirtualLicenseOrderResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateOrGetVirtualLicenseOrderResponse
		var err error
		defer close(result)
		response, err = client.CreateOrGetVirtualLicenseOrder(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateOrGetVirtualLicenseOrderRequest is the request struct for api CreateOrGetVirtualLicenseOrder
type CreateOrGetVirtualLicenseOrderRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	Engine               string           `position:"Query" name:"Engine"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// CreateOrGetVirtualLicenseOrderResponse is the response struct for api CreateOrGetVirtualLicenseOrder
type CreateOrGetVirtualLicenseOrderResponse struct {
	*responses.BaseResponse
	ActivatedCodeCount         int    `json:"ActivatedCodeCount" xml:"ActivatedCodeCount"`
	ActivationCodeQuota        int    `json:"ActivationCodeQuota" xml:"ActivationCodeQuota"`
	AliyunOrderId              string `json:"AliyunOrderId" xml:"AliyunOrderId"`
	AllowEmptySystemIdentifier bool   `json:"AllowEmptySystemIdentifier" xml:"AllowEmptySystemIdentifier"`
	GmtCreated                 string `json:"GmtCreated" xml:"GmtCreated"`
	GmtModified                string `json:"GmtModified" xml:"GmtModified"`
	IsVirtualOrder             bool   `json:"IsVirtualOrder" xml:"IsVirtualOrder"`
	IsVirtualOrderFrozen       bool   `json:"IsVirtualOrderFrozen" xml:"IsVirtualOrderFrozen"`
	PackageType                string `json:"PackageType" xml:"PackageType"`
	PackageValidity            string `json:"PackageValidity" xml:"PackageValidity"`
	PurchaseChannel            string `json:"PurchaseChannel" xml:"PurchaseChannel"`
	RequestId                  string `json:"RequestId" xml:"RequestId"`
	VirtualOrderId             string `json:"VirtualOrderId" xml:"VirtualOrderId"`
}

// CreateCreateOrGetVirtualLicenseOrderRequest creates a request to invoke CreateOrGetVirtualLicenseOrder API
func CreateCreateOrGetVirtualLicenseOrderRequest() (request *CreateOrGetVirtualLicenseOrderRequest) {
	request = &CreateOrGetVirtualLicenseOrderRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("polardb", "2017-08-01", "CreateOrGetVirtualLicenseOrder", "polardb", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateOrGetVirtualLicenseOrderResponse creates a response to parse from CreateOrGetVirtualLicenseOrder response
func CreateCreateOrGetVirtualLicenseOrderResponse() (response *CreateOrGetVirtualLicenseOrderResponse) {
	response = &CreateOrGetVirtualLicenseOrderResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
