package polardbx

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AlignStoragePrimaryAzone invokes the polardbx.AlignStoragePrimaryAzone API synchronously
func (client *Client) AlignStoragePrimaryAzone(request *AlignStoragePrimaryAzoneRequest) (response *AlignStoragePrimaryAzoneResponse, err error) {
	response = CreateAlignStoragePrimaryAzoneResponse()
	err = client.DoAction(request, response)
	return
}

// AlignStoragePrimaryAzoneWithChan invokes the polardbx.AlignStoragePrimaryAzone API asynchronously
func (client *Client) AlignStoragePrimaryAzoneWithChan(request *AlignStoragePrimaryAzoneRequest) (<-chan *AlignStoragePrimaryAzoneResponse, <-chan error) {
	responseChan := make(chan *AlignStoragePrimaryAzoneResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AlignStoragePrimaryAzone(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AlignStoragePrimaryAzoneWithCallback invokes the polardbx.AlignStoragePrimaryAzone API asynchronously
func (client *Client) AlignStoragePrimaryAzoneWithCallback(request *AlignStoragePrimaryAzoneRequest, callback func(response *AlignStoragePrimaryAzoneResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AlignStoragePrimaryAzoneResponse
		var err error
		defer close(result)
		response, err = client.AlignStoragePrimaryAzone(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AlignStoragePrimaryAzoneRequest is the request struct for api AlignStoragePrimaryAzone
type AlignStoragePrimaryAzoneRequest struct {
	*requests.RpcRequest
	DBInstanceName      string `position:"Query" name:"DBInstanceName"`
	SwitchTimeMode      string `position:"Query" name:"SwitchTimeMode"`
	SwitchTime          string `position:"Query" name:"SwitchTime"`
	StorageInstanceName string `position:"Query" name:"StorageInstanceName"`
}

// AlignStoragePrimaryAzoneResponse is the response struct for api AlignStoragePrimaryAzone
type AlignStoragePrimaryAzoneResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateAlignStoragePrimaryAzoneRequest creates a request to invoke AlignStoragePrimaryAzone API
func CreateAlignStoragePrimaryAzoneRequest() (request *AlignStoragePrimaryAzoneRequest) {
	request = &AlignStoragePrimaryAzoneRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("polardbx", "2020-02-02", "AlignStoragePrimaryAzone", "polardbx", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAlignStoragePrimaryAzoneResponse creates a response to parse from AlignStoragePrimaryAzone response
func CreateAlignStoragePrimaryAzoneResponse() (response *AlignStoragePrimaryAzoneResponse) {
	response = &AlignStoragePrimaryAzoneResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
