package privatelink

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListVpcEndpointServices invokes the privatelink.ListVpcEndpointServices API synchronously
func (client *Client) ListVpcEndpointServices(request *ListVpcEndpointServicesRequest) (response *ListVpcEndpointServicesResponse, err error) {
	response = CreateListVpcEndpointServicesResponse()
	err = client.DoAction(request, response)
	return
}

// ListVpcEndpointServicesWithChan invokes the privatelink.ListVpcEndpointServices API asynchronously
func (client *Client) ListVpcEndpointServicesWithChan(request *ListVpcEndpointServicesRequest) (<-chan *ListVpcEndpointServicesResponse, <-chan error) {
	responseChan := make(chan *ListVpcEndpointServicesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListVpcEndpointServices(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListVpcEndpointServicesWithCallback invokes the privatelink.ListVpcEndpointServices API asynchronously
func (client *Client) ListVpcEndpointServicesWithCallback(request *ListVpcEndpointServicesRequest, callback func(response *ListVpcEndpointServicesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListVpcEndpointServicesResponse
		var err error
		defer close(result)
		response, err = client.ListVpcEndpointServices(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListVpcEndpointServicesRequest is the request struct for api ListVpcEndpointServices
type ListVpcEndpointServicesRequest struct {
	*requests.RpcRequest
	ServiceBusinessStatus string                        `position:"Query" name:"ServiceBusinessStatus"`
	AutoAcceptEnabled     requests.Boolean              `position:"Query" name:"AutoAcceptEnabled"`
	ServiceStatus         string                        `position:"Query" name:"ServiceStatus"`
	ResourceGroupId       string                        `position:"Query" name:"ResourceGroupId"`
	NextToken             string                        `position:"Query" name:"NextToken"`
	ZoneAffinityEnabled   requests.Boolean              `position:"Query" name:"ZoneAffinityEnabled"`
	ServiceName           string                        `position:"Query" name:"ServiceName"`
	Tag                   *[]ListVpcEndpointServicesTag `position:"Query" name:"Tag"  type:"Repeated"`
	ResourceId            string                        `position:"Query" name:"ResourceId"`
	ServiceResourceType   string                        `position:"Query" name:"ServiceResourceType"`
	MaxResults            requests.Integer              `position:"Query" name:"MaxResults"`
	ServiceId             string                        `position:"Query" name:"ServiceId"`
}

// ListVpcEndpointServicesTag is a repeated param struct in ListVpcEndpointServicesRequest
type ListVpcEndpointServicesTag struct {
	Key   string `name:"Key"`
	Value string `name:"Value"`
}

// ListVpcEndpointServicesResponse is the response struct for api ListVpcEndpointServices
type ListVpcEndpointServicesResponse struct {
	*responses.BaseResponse
	NextToken  string    `json:"NextToken" xml:"NextToken"`
	RequestId  string    `json:"RequestId" xml:"RequestId"`
	MaxResults int       `json:"MaxResults" xml:"MaxResults"`
	TotalCount int       `json:"TotalCount" xml:"TotalCount"`
	Services   []Service `json:"Services" xml:"Services"`
}

// CreateListVpcEndpointServicesRequest creates a request to invoke ListVpcEndpointServices API
func CreateListVpcEndpointServicesRequest() (request *ListVpcEndpointServicesRequest) {
	request = &ListVpcEndpointServicesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Privatelink", "2020-04-15", "ListVpcEndpointServices", "privatelink", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListVpcEndpointServicesResponse creates a response to parse from ListVpcEndpointServices response
func CreateListVpcEndpointServicesResponse() (response *ListVpcEndpointServicesResponse) {
	response = &ListVpcEndpointServicesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
