package pts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListPtsScene invokes the pts.ListPtsScene API synchronously
func (client *Client) ListPtsScene(request *ListPtsSceneRequest) (response *ListPtsSceneResponse, err error) {
	response = CreateListPtsSceneResponse()
	err = client.DoAction(request, response)
	return
}

// ListPtsSceneWithChan invokes the pts.ListPtsScene API asynchronously
func (client *Client) ListPtsSceneWithChan(request *ListPtsSceneRequest) (<-chan *ListPtsSceneResponse, <-chan error) {
	responseChan := make(chan *ListPtsSceneResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListPtsScene(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListPtsSceneWithCallback invokes the pts.ListPtsScene API asynchronously
func (client *Client) ListPtsSceneWithCallback(request *ListPtsSceneRequest, callback func(response *ListPtsSceneResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListPtsSceneResponse
		var err error
		defer close(result)
		response, err = client.ListPtsScene(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListPtsSceneRequest is the request struct for api ListPtsScene
type ListPtsSceneRequest struct {
	*requests.RpcRequest
	PageSize   requests.Integer `position:"Query" name:"PageSize"`
	KeyWord    string           `position:"Query" name:"KeyWord"`
	PageNumber requests.Integer `position:"Query" name:"PageNumber"`
}

// ListPtsSceneResponse is the response struct for api ListPtsScene
type ListPtsSceneResponse struct {
	*responses.BaseResponse
	Message        string      `json:"Message" xml:"Message"`
	RequestId      string      `json:"RequestId" xml:"RequestId"`
	HttpStatusCode int         `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Code           string      `json:"Code" xml:"Code"`
	Success        bool        `json:"Success" xml:"Success"`
	SceneViewList  []SceneView `json:"SceneViewList" xml:"SceneViewList"`
}

// CreateListPtsSceneRequest creates a request to invoke ListPtsScene API
func CreateListPtsSceneRequest() (request *ListPtsSceneRequest) {
	request = &ListPtsSceneRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("PTS", "2020-10-20", "ListPtsScene", "", "")
	request.Method = requests.POST
	return
}

// CreateListPtsSceneResponse creates a response to parse from ListPtsScene response
func CreateListPtsSceneResponse() (response *ListPtsSceneResponse) {
	response = &ListPtsSceneResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
