package qualitycheck

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListWarningStrategyConfig invokes the qualitycheck.ListWarningStrategyConfig API synchronously
func (client *Client) ListWarningStrategyConfig(request *ListWarningStrategyConfigRequest) (response *ListWarningStrategyConfigResponse, err error) {
	response = CreateListWarningStrategyConfigResponse()
	err = client.DoAction(request, response)
	return
}

// ListWarningStrategyConfigWithChan invokes the qualitycheck.ListWarningStrategyConfig API asynchronously
func (client *Client) ListWarningStrategyConfigWithChan(request *ListWarningStrategyConfigRequest) (<-chan *ListWarningStrategyConfigResponse, <-chan error) {
	responseChan := make(chan *ListWarningStrategyConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListWarningStrategyConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListWarningStrategyConfigWithCallback invokes the qualitycheck.ListWarningStrategyConfig API asynchronously
func (client *Client) ListWarningStrategyConfigWithCallback(request *ListWarningStrategyConfigRequest, callback func(response *ListWarningStrategyConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListWarningStrategyConfigResponse
		var err error
		defer close(result)
		response, err = client.ListWarningStrategyConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListWarningStrategyConfigRequest is the request struct for api ListWarningStrategyConfig
type ListWarningStrategyConfigRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	JsonStr         string           `position:"Query" name:"JsonStr"`
	BaseMeAgentId   requests.Integer `position:"Query" name:"BaseMeAgentId"`
}

// ListWarningStrategyConfigResponse is the response struct for api ListWarningStrategyConfig
type ListWarningStrategyConfigResponse struct {
	*responses.BaseResponse
	Message   string                          `json:"Message" xml:"Message"`
	RequestId string                          `json:"RequestId" xml:"RequestId"`
	Code      string                          `json:"Code" xml:"Code"`
	Success   bool                            `json:"Success" xml:"Success"`
	Count     int                             `json:"Count" xml:"Count"`
	Data      DataInListWarningStrategyConfig `json:"Data" xml:"Data"`
}

// CreateListWarningStrategyConfigRequest creates a request to invoke ListWarningStrategyConfig API
func CreateListWarningStrategyConfigRequest() (request *ListWarningStrategyConfigRequest) {
	request = &ListWarningStrategyConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Qualitycheck", "2019-01-15", "ListWarningStrategyConfig", "", "")
	request.Method = requests.POST
	return
}

// CreateListWarningStrategyConfigResponse creates a response to parse from ListWarningStrategyConfig response
func CreateListWarningStrategyConfigResponse() (response *ListWarningStrategyConfigResponse) {
	response = &ListWarningStrategyConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
