package quickbi_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateTicket4Copilot invokes the quickbi_public.CreateTicket4Copilot API synchronously
func (client *Client) CreateTicket4Copilot(request *CreateTicket4CopilotRequest) (response *CreateTicket4CopilotResponse, err error) {
	response = CreateCreateTicket4CopilotResponse()
	err = client.DoAction(request, response)
	return
}

// CreateTicket4CopilotWithChan invokes the quickbi_public.CreateTicket4Copilot API asynchronously
func (client *Client) CreateTicket4CopilotWithChan(request *CreateTicket4CopilotRequest) (<-chan *CreateTicket4CopilotResponse, <-chan error) {
	responseChan := make(chan *CreateTicket4CopilotResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateTicket4Copilot(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateTicket4CopilotWithCallback invokes the quickbi_public.CreateTicket4Copilot API asynchronously
func (client *Client) CreateTicket4CopilotWithCallback(request *CreateTicket4CopilotRequest, callback func(response *CreateTicket4CopilotResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateTicket4CopilotResponse
		var err error
		defer close(result)
		response, err = client.CreateTicket4Copilot(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateTicket4CopilotRequest is the request struct for api CreateTicket4Copilot
type CreateTicket4CopilotRequest struct {
	*requests.RpcRequest
	CopilotId   string           `position:"Query" name:"CopilotId"`
	AccessPoint string           `position:"Query" name:"AccessPoint"`
	AccountType requests.Integer `position:"Query" name:"AccountType"`
	UserId      string           `position:"Query" name:"UserId"`
	AccountName string           `position:"Query" name:"AccountName"`
	ExpireTime  requests.Integer `position:"Query" name:"ExpireTime"`
	SignType    string           `position:"Query" name:"SignType"`
	TicketNum   requests.Integer `position:"Query" name:"TicketNum"`
}

// CreateTicket4CopilotResponse is the response struct for api CreateTicket4Copilot
type CreateTicket4CopilotResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    string `json:"Result" xml:"Result"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateCreateTicket4CopilotRequest creates a request to invoke CreateTicket4Copilot API
func CreateCreateTicket4CopilotRequest() (request *CreateTicket4CopilotRequest) {
	request = &CreateTicket4CopilotRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("quickbi-public", "2022-01-01", "CreateTicket4Copilot", "2.2.0", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateTicket4CopilotResponse creates a response to parse from CreateTicket4Copilot response
func CreateCreateTicket4CopilotResponse() (response *CreateTicket4CopilotResponse) {
	response = &CreateTicket4CopilotResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
