package r_kvstore

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeParameterGroupTemplateList invokes the r_kvstore.DescribeParameterGroupTemplateList API synchronously
func (client *Client) DescribeParameterGroupTemplateList(request *DescribeParameterGroupTemplateListRequest) (response *DescribeParameterGroupTemplateListResponse, err error) {
	response = CreateDescribeParameterGroupTemplateListResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeParameterGroupTemplateListWithChan invokes the r_kvstore.DescribeParameterGroupTemplateList API asynchronously
func (client *Client) DescribeParameterGroupTemplateListWithChan(request *DescribeParameterGroupTemplateListRequest) (<-chan *DescribeParameterGroupTemplateListResponse, <-chan error) {
	responseChan := make(chan *DescribeParameterGroupTemplateListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeParameterGroupTemplateList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeParameterGroupTemplateListWithCallback invokes the r_kvstore.DescribeParameterGroupTemplateList API asynchronously
func (client *Client) DescribeParameterGroupTemplateListWithCallback(request *DescribeParameterGroupTemplateListRequest, callback func(response *DescribeParameterGroupTemplateListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeParameterGroupTemplateListResponse
		var err error
		defer close(result)
		response, err = client.DescribeParameterGroupTemplateList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeParameterGroupTemplateListRequest is the request struct for api DescribeParameterGroupTemplateList
type DescribeParameterGroupTemplateListRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	EngineVersion        string           `position:"Query" name:"EngineVersion"`
	SecurityToken        string           `position:"Query" name:"SecurityToken"`
	EngineType           string           `position:"Query" name:"EngineType"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	Category             string           `position:"Query" name:"Category"`
	CharacterType        string           `position:"Query" name:"CharacterType"`
}

// DescribeParameterGroupTemplateListResponse is the response struct for api DescribeParameterGroupTemplateList
type DescribeParameterGroupTemplateListResponse struct {
	*responses.BaseResponse
	RequestId     string           `json:"RequestId" xml:"RequestId"`
	EngineVersion string           `json:"EngineVersion" xml:"EngineVersion"`
	Parameters    []ParametersItem `json:"Parameters" xml:"Parameters"`
}

// CreateDescribeParameterGroupTemplateListRequest creates a request to invoke DescribeParameterGroupTemplateList API
func CreateDescribeParameterGroupTemplateListRequest() (request *DescribeParameterGroupTemplateListRequest) {
	request = &DescribeParameterGroupTemplateListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("R-kvstore", "2015-01-01", "DescribeParameterGroupTemplateList", "redisa", "openAPI")
	request.Method = requests.GET
	return
}

// CreateDescribeParameterGroupTemplateListResponse creates a response to parse from DescribeParameterGroupTemplateList response
func CreateDescribeParameterGroupTemplateListResponse() (response *DescribeParameterGroupTemplateListResponse) {
	response = &DescribeParameterGroupTemplateListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
