package rds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateDBInstanceSecurityGroupRule invokes the rds.CreateDBInstanceSecurityGroupRule API synchronously
func (client *Client) CreateDBInstanceSecurityGroupRule(request *CreateDBInstanceSecurityGroupRuleRequest) (response *CreateDBInstanceSecurityGroupRuleResponse, err error) {
	response = CreateCreateDBInstanceSecurityGroupRuleResponse()
	err = client.DoAction(request, response)
	return
}

// CreateDBInstanceSecurityGroupRuleWithChan invokes the rds.CreateDBInstanceSecurityGroupRule API asynchronously
func (client *Client) CreateDBInstanceSecurityGroupRuleWithChan(request *CreateDBInstanceSecurityGroupRuleRequest) (<-chan *CreateDBInstanceSecurityGroupRuleResponse, <-chan error) {
	responseChan := make(chan *CreateDBInstanceSecurityGroupRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateDBInstanceSecurityGroupRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateDBInstanceSecurityGroupRuleWithCallback invokes the rds.CreateDBInstanceSecurityGroupRule API asynchronously
func (client *Client) CreateDBInstanceSecurityGroupRuleWithCallback(request *CreateDBInstanceSecurityGroupRuleRequest, callback func(response *CreateDBInstanceSecurityGroupRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateDBInstanceSecurityGroupRuleResponse
		var err error
		defer close(result)
		response, err = client.CreateDBInstanceSecurityGroupRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateDBInstanceSecurityGroupRuleRequest is the request struct for api CreateDBInstanceSecurityGroupRule
type CreateDBInstanceSecurityGroupRuleRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClientToken          string           `position:"Query" name:"ClientToken"`
	Description          string           `position:"Query" name:"Description"`
	ResourceGroupId      string           `position:"Query" name:"ResourceGroupId"`
	DBInstanceId         string           `position:"Query" name:"DBInstanceId"`
	PortRange            string           `position:"Query" name:"PortRange"`
	IpProtocol           string           `position:"Query" name:"IpProtocol"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	SourceCidrIp         string           `position:"Query" name:"SourceCidrIp"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              string           `position:"Query" name:"OwnerId"`
}

// CreateDBInstanceSecurityGroupRuleResponse is the response struct for api CreateDBInstanceSecurityGroupRule
type CreateDBInstanceSecurityGroupRuleResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Message   string `json:"Message" xml:"Message"`
	Code      string `json:"Code" xml:"Code"`
}

// CreateCreateDBInstanceSecurityGroupRuleRequest creates a request to invoke CreateDBInstanceSecurityGroupRule API
func CreateCreateDBInstanceSecurityGroupRuleRequest() (request *CreateDBInstanceSecurityGroupRuleRequest) {
	request = &CreateDBInstanceSecurityGroupRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Rds", "2014-08-15", "CreateDBInstanceSecurityGroupRule", "rds", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateDBInstanceSecurityGroupRuleResponse creates a response to parse from CreateDBInstanceSecurityGroupRule response
func CreateCreateDBInstanceSecurityGroupRuleResponse() (response *CreateDBInstanceSecurityGroupRuleResponse) {
	response = &CreateDBInstanceSecurityGroupRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
