package rds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryRecommendByCode invokes the rds.QueryRecommendByCode API synchronously
func (client *Client) QueryRecommendByCode(request *QueryRecommendByCodeRequest) (response *QueryRecommendByCodeResponse, err error) {
	response = CreateQueryRecommendByCodeResponse()
	err = client.DoAction(request, response)
	return
}

// QueryRecommendByCodeWithChan invokes the rds.QueryRecommendByCode API asynchronously
func (client *Client) QueryRecommendByCodeWithChan(request *QueryRecommendByCodeRequest) (<-chan *QueryRecommendByCodeResponse, <-chan error) {
	responseChan := make(chan *QueryRecommendByCodeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryRecommendByCode(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryRecommendByCodeWithCallback invokes the rds.QueryRecommendByCode API asynchronously
func (client *Client) QueryRecommendByCodeWithCallback(request *QueryRecommendByCodeRequest, callback func(response *QueryRecommendByCodeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryRecommendByCodeResponse
		var err error
		defer close(result)
		response, err = client.QueryRecommendByCode(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryRecommendByCodeRequest is the request struct for api QueryRecommendByCode
type QueryRecommendByCodeRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      string `position:"Query" name:"ResourceOwnerId"`
	Code                 string `position:"Query" name:"Code"`
	ResourceGroupId      string `position:"Query" name:"ResourceGroupId"`
	ResourceOwnerAccount string `position:"Query" name:"ResourceOwnerAccount"`
	OwnerId              string `position:"Query" name:"OwnerId"`
}

// QueryRecommendByCodeResponse is the response struct for api QueryRecommendByCode
type QueryRecommendByCodeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      string `json:"Data" xml:"Data"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateQueryRecommendByCodeRequest creates a request to invoke QueryRecommendByCode API
func CreateQueryRecommendByCodeRequest() (request *QueryRecommendByCodeRequest) {
	request = &QueryRecommendByCodeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Rds", "2014-08-15", "QueryRecommendByCode", "rds", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQueryRecommendByCodeResponse creates a response to parse from QueryRecommendByCode response
func CreateQueryRecommendByCodeResponse() (response *QueryRecommendByCodeResponse) {
	response = &QueryRecommendByCodeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
