package resourcecenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// EnableResourceCenter invokes the resourcecenter.EnableResourceCenter API synchronously
func (client *Client) EnableResourceCenter(request *EnableResourceCenterRequest) (response *EnableResourceCenterResponse, err error) {
	response = CreateEnableResourceCenterResponse()
	err = client.DoAction(request, response)
	return
}

// EnableResourceCenterWithChan invokes the resourcecenter.EnableResourceCenter API asynchronously
func (client *Client) EnableResourceCenterWithChan(request *EnableResourceCenterRequest) (<-chan *EnableResourceCenterResponse, <-chan error) {
	responseChan := make(chan *EnableResourceCenterResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.EnableResourceCenter(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// EnableResourceCenterWithCallback invokes the resourcecenter.EnableResourceCenter API asynchronously
func (client *Client) EnableResourceCenterWithCallback(request *EnableResourceCenterRequest, callback func(response *EnableResourceCenterResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *EnableResourceCenterResponse
		var err error
		defer close(result)
		response, err = client.EnableResourceCenter(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// EnableResourceCenterRequest is the request struct for api EnableResourceCenter
type EnableResourceCenterRequest struct {
	*requests.RpcRequest
	Channel string `position:"Query" name:"Channel"`
}

// EnableResourceCenterResponse is the response struct for api EnableResourceCenter
type EnableResourceCenterResponse struct {
	*responses.BaseResponse
	Status    string `json:"Status" xml:"Status"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateEnableResourceCenterRequest creates a request to invoke EnableResourceCenter API
func CreateEnableResourceCenterRequest() (request *EnableResourceCenterRequest) {
	request = &EnableResourceCenterRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ResourceCenter", "2022-12-01", "EnableResourceCenter", "", "")
	request.Method = requests.POST
	return
}

// CreateEnableResourceCenterResponse creates a response to parse from EnableResourceCenter response
func CreateEnableResourceCenterResponse() (response *EnableResourceCenterResponse) {
	response = &EnableResourceCenterResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
