package resourcemanager

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetPayerForAccount invokes the resourcemanager.GetPayerForAccount API synchronously
func (client *Client) GetPayerForAccount(request *GetPayerForAccountRequest) (response *GetPayerForAccountResponse, err error) {
	response = CreateGetPayerForAccountResponse()
	err = client.DoAction(request, response)
	return
}

// GetPayerForAccountWithChan invokes the resourcemanager.GetPayerForAccount API asynchronously
func (client *Client) GetPayerForAccountWithChan(request *GetPayerForAccountRequest) (<-chan *GetPayerForAccountResponse, <-chan error) {
	responseChan := make(chan *GetPayerForAccountResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetPayerForAccount(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetPayerForAccountWithCallback invokes the resourcemanager.GetPayerForAccount API asynchronously
func (client *Client) GetPayerForAccountWithCallback(request *GetPayerForAccountRequest, callback func(response *GetPayerForAccountResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetPayerForAccountResponse
		var err error
		defer close(result)
		response, err = client.GetPayerForAccount(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetPayerForAccountRequest is the request struct for api GetPayerForAccount
type GetPayerForAccountRequest struct {
	*requests.RpcRequest
	AccountId string `position:"Query" name:"AccountId"`
}

// GetPayerForAccountResponse is the response struct for api GetPayerForAccount
type GetPayerForAccountResponse struct {
	*responses.BaseResponse
	PayerAccountName string `json:"PayerAccountName" xml:"PayerAccountName"`
	RequestId        string `json:"RequestId" xml:"RequestId"`
	PayerAccountId   string `json:"PayerAccountId" xml:"PayerAccountId"`
}

// CreateGetPayerForAccountRequest creates a request to invoke GetPayerForAccount API
func CreateGetPayerForAccountRequest() (request *GetPayerForAccountRequest) {
	request = &GetPayerForAccountRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ResourceManager", "2020-03-31", "GetPayerForAccount", "resourcemanager", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetPayerForAccountResponse creates a response to parse from GetPayerForAccount response
func CreateGetPayerForAccountResponse() (response *GetPayerForAccountResponse) {
	response = &GetPayerForAccountResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
