package retailadvqa_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetAudienceMarketingInfo invokes the retailadvqa_public.GetAudienceMarketingInfo API synchronously
func (client *Client) GetAudienceMarketingInfo(request *GetAudienceMarketingInfoRequest) (response *GetAudienceMarketingInfoResponse, err error) {
	response = CreateGetAudienceMarketingInfoResponse()
	err = client.DoAction(request, response)
	return
}

// GetAudienceMarketingInfoWithChan invokes the retailadvqa_public.GetAudienceMarketingInfo API asynchronously
func (client *Client) GetAudienceMarketingInfoWithChan(request *GetAudienceMarketingInfoRequest) (<-chan *GetAudienceMarketingInfoResponse, <-chan error) {
	responseChan := make(chan *GetAudienceMarketingInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetAudienceMarketingInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetAudienceMarketingInfoWithCallback invokes the retailadvqa_public.GetAudienceMarketingInfo API asynchronously
func (client *Client) GetAudienceMarketingInfoWithCallback(request *GetAudienceMarketingInfoRequest, callback func(response *GetAudienceMarketingInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetAudienceMarketingInfoResponse
		var err error
		defer close(result)
		response, err = client.GetAudienceMarketingInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetAudienceMarketingInfoRequest is the request struct for api GetAudienceMarketingInfo
type GetAudienceMarketingInfoRequest struct {
	*requests.RpcRequest
	AccessId                  string           `position:"Query" name:"AccessId"`
	PageSize                  requests.Integer `position:"Query" name:"PageSize"`
	LatestDataModifyStartTime string           `position:"Query" name:"LatestDataModifyStartTime"`
	LatestDataModifyEndTime   string           `position:"Query" name:"LatestDataModifyEndTime"`
	PageNum                   requests.Integer `position:"Query" name:"PageNum"`
	WorkspaceId               string           `position:"Query" name:"WorkspaceId"`
}

// GetAudienceMarketingInfoResponse is the response struct for api GetAudienceMarketingInfo
type GetAudienceMarketingInfoResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	ErrorDesc string `json:"ErrorDesc" xml:"ErrorDesc"`
	TraceId   string `json:"TraceId" xml:"TraceId"`
	ErrorCode string `json:"ErrorCode" xml:"ErrorCode"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateGetAudienceMarketingInfoRequest creates a request to invoke GetAudienceMarketingInfo API
func CreateGetAudienceMarketingInfoRequest() (request *GetAudienceMarketingInfoRequest) {
	request = &GetAudienceMarketingInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("retailadvqa-public", "2020-05-15", "GetAudienceMarketingInfo", "", "")
	request.Method = requests.POST
	return
}

// CreateGetAudienceMarketingInfoResponse creates a response to parse from GetAudienceMarketingInfo response
func CreateGetAudienceMarketingInfoResponse() (response *GetAudienceMarketingInfoResponse) {
	response = &GetAudienceMarketingInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
