package retailadvqa_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SaveLabelImportTask invokes the retailadvqa_public.SaveLabelImportTask API synchronously
func (client *Client) SaveLabelImportTask(request *SaveLabelImportTaskRequest) (response *SaveLabelImportTaskResponse, err error) {
	response = CreateSaveLabelImportTaskResponse()
	err = client.DoAction(request, response)
	return
}

// SaveLabelImportTaskWithChan invokes the retailadvqa_public.SaveLabelImportTask API asynchronously
func (client *Client) SaveLabelImportTaskWithChan(request *SaveLabelImportTaskRequest) (<-chan *SaveLabelImportTaskResponse, <-chan error) {
	responseChan := make(chan *SaveLabelImportTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SaveLabelImportTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SaveLabelImportTaskWithCallback invokes the retailadvqa_public.SaveLabelImportTask API asynchronously
func (client *Client) SaveLabelImportTaskWithCallback(request *SaveLabelImportTaskRequest, callback func(response *SaveLabelImportTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SaveLabelImportTaskResponse
		var err error
		defer close(result)
		response, err = client.SaveLabelImportTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SaveLabelImportTaskRequest is the request struct for api SaveLabelImportTask
type SaveLabelImportTaskRequest struct {
	*requests.RpcRequest
	AccessId                       string                                               `position:"Query" name:"AccessId"`
	FilePath                       string                                               `position:"Body" name:"FilePath"`
	LabelImportTaskColumnModelList *[]SaveLabelImportTaskLabelImportTaskColumnModelList `position:"Body" name:"LabelImportTaskColumnModelList"  type:"Json"`
	Delimiter                      string                                               `position:"Body" name:"Delimiter"`
	TenantId                       string                                               `position:"Query" name:"TenantId"`
	FileFormat                     string                                               `position:"Body" name:"FileFormat"`
	TableName                      string                                               `position:"Body" name:"TableName"`
	TaskId                         string                                               `position:"Body" name:"TaskId"`
	WorkspaceId                    string                                               `position:"Body" name:"WorkspaceId"`
	TableDesc                      string                                               `position:"Body" name:"TableDesc"`
}

// SaveLabelImportTaskLabelImportTaskColumnModelList is a repeated param struct in SaveLabelImportTaskRequest
type SaveLabelImportTaskLabelImportTaskColumnModelList struct {
	IdentityType   string `name:"IdentityType"`
	LabelSeparator string `name:"LabelSeparator"`
	LabelDesc      string `name:"LabelDesc"`
	EncryptionType string `name:"EncryptionType"`
	LabelAlias     string `name:"LabelAlias"`
	LabelType      string `name:"LabelType"`
	ColumnName     string `name:"ColumnName"`
	ColumnType     string `name:"ColumnType"`
	PrimaryKey     string `name:"PrimaryKey"`
}

// SaveLabelImportTaskResponse is the response struct for api SaveLabelImportTask
type SaveLabelImportTaskResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	ErrorDesc string `json:"ErrorDesc" xml:"ErrorDesc"`
	TraceId   string `json:"TraceId" xml:"TraceId"`
	ErrorCode string `json:"ErrorCode" xml:"ErrorCode"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateSaveLabelImportTaskRequest creates a request to invoke SaveLabelImportTask API
func CreateSaveLabelImportTaskRequest() (request *SaveLabelImportTaskRequest) {
	request = &SaveLabelImportTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("retailadvqa-public", "2020-05-15", "SaveLabelImportTask", "", "")
	request.Method = requests.POST
	return
}

// CreateSaveLabelImportTaskResponse creates a response to parse from SaveLabelImportTask response
func CreateSaveLabelImportTaskResponse() (response *SaveLabelImportTaskResponse) {
	response = &SaveLabelImportTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
