package retailadvqa_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateDataset invokes the retailadvqa_public.UpdateDataset API synchronously
func (client *Client) UpdateDataset(request *UpdateDatasetRequest) (response *UpdateDatasetResponse, err error) {
	response = CreateUpdateDatasetResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateDatasetWithChan invokes the retailadvqa_public.UpdateDataset API asynchronously
func (client *Client) UpdateDatasetWithChan(request *UpdateDatasetRequest) (<-chan *UpdateDatasetResponse, <-chan error) {
	responseChan := make(chan *UpdateDatasetResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateDataset(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateDatasetWithCallback invokes the retailadvqa_public.UpdateDataset API asynchronously
func (client *Client) UpdateDatasetWithCallback(request *UpdateDatasetRequest, callback func(response *UpdateDatasetResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateDatasetResponse
		var err error
		defer close(result)
		response, err = client.UpdateDataset(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateDatasetRequest is the request struct for api UpdateDataset
type UpdateDatasetRequest struct {
	*requests.RpcRequest
	AccessId    string `position:"Body" name:"AccessId"`
	TenantId    string `position:"Body" name:"TenantId"`
	DataSetName string `position:"Body" name:"DataSetName"`
	DataSetId   string `position:"Body" name:"DataSetId"`
	Type        string `position:"Body" name:"Type"`
	DataSet     string `position:"Body" name:"DataSet"`
	WorkspaceId string `position:"Body" name:"WorkspaceId"`
}

// UpdateDatasetResponse is the response struct for api UpdateDataset
type UpdateDatasetResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	ErrorDesc string `json:"ErrorDesc" xml:"ErrorDesc"`
	TraceId   string `json:"TraceId" xml:"TraceId"`
	Data      string `json:"Data" xml:"Data"`
	ErrorCode string `json:"ErrorCode" xml:"ErrorCode"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateUpdateDatasetRequest creates a request to invoke UpdateDataset API
func CreateUpdateDatasetRequest() (request *UpdateDatasetRequest) {
	request = &UpdateDatasetRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("retailadvqa-public", "2020-05-15", "UpdateDataset", "", "")
	request.Method = requests.POST
	return
}

// CreateUpdateDatasetResponse creates a response to parse from UpdateDataset response
func CreateUpdateDatasetResponse() (response *UpdateDatasetResponse) {
	response = &UpdateDatasetResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
