package retailcloud

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteDeployConfig invokes the retailcloud.DeleteDeployConfig API synchronously
func (client *Client) DeleteDeployConfig(request *DeleteDeployConfigRequest) (response *DeleteDeployConfigResponse, err error) {
	response = CreateDeleteDeployConfigResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteDeployConfigWithChan invokes the retailcloud.DeleteDeployConfig API asynchronously
func (client *Client) DeleteDeployConfigWithChan(request *DeleteDeployConfigRequest) (<-chan *DeleteDeployConfigResponse, <-chan error) {
	responseChan := make(chan *DeleteDeployConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteDeployConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteDeployConfigWithCallback invokes the retailcloud.DeleteDeployConfig API asynchronously
func (client *Client) DeleteDeployConfigWithCallback(request *DeleteDeployConfigRequest, callback func(response *DeleteDeployConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteDeployConfigResponse
		var err error
		defer close(result)
		response, err = client.DeleteDeployConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteDeployConfigRequest is the request struct for api DeleteDeployConfig
type DeleteDeployConfigRequest struct {
	*requests.RpcRequest
	SchemaId requests.Integer `position:"Query" name:"SchemaId"`
}

// DeleteDeployConfigResponse is the response struct for api DeleteDeployConfig
type DeleteDeployConfigResponse struct {
	*responses.BaseResponse
	Code      int    `json:"Code" xml:"Code"`
	ErrMsg    string `json:"ErrMsg" xml:"ErrMsg"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    Result `json:"Result" xml:"Result"`
}

// CreateDeleteDeployConfigRequest creates a request to invoke DeleteDeployConfig API
func CreateDeleteDeployConfigRequest() (request *DeleteDeployConfigRequest) {
	request = &DeleteDeployConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("retailcloud", "2018-03-13", "DeleteDeployConfig", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteDeployConfigResponse creates a response to parse from DeleteDeployConfig response
func CreateDeleteDeployConfigResponse() (response *DeleteDeployConfigResponse) {
	response = &DeleteDeployConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
