package retailcloud

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListAppGroup invokes the retailcloud.ListAppGroup API synchronously
func (client *Client) ListAppGroup(request *ListAppGroupRequest) (response *ListAppGroupResponse, err error) {
	response = CreateListAppGroupResponse()
	err = client.DoAction(request, response)
	return
}

// ListAppGroupWithChan invokes the retailcloud.ListAppGroup API asynchronously
func (client *Client) ListAppGroupWithChan(request *ListAppGroupRequest) (<-chan *ListAppGroupResponse, <-chan error) {
	responseChan := make(chan *ListAppGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListAppGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListAppGroupWithCallback invokes the retailcloud.ListAppGroup API asynchronously
func (client *Client) ListAppGroupWithCallback(request *ListAppGroupRequest, callback func(response *ListAppGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListAppGroupResponse
		var err error
		defer close(result)
		response, err = client.ListAppGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListAppGroupRequest is the request struct for api ListAppGroup
type ListAppGroupRequest struct {
	*requests.RpcRequest
	BizCode    string           `position:"Query" name:"BizCode"`
	PageSize   requests.Integer `position:"Query" name:"PageSize"`
	PageNumber requests.Integer `position:"Query" name:"PageNumber"`
}

// ListAppGroupResponse is the response struct for api ListAppGroup
type ListAppGroupResponse struct {
	*responses.BaseResponse
	Code       int              `json:"Code" xml:"Code"`
	PageNumber int              `json:"PageNumber" xml:"PageNumber"`
	RequestId  string           `json:"RequestId" xml:"RequestId"`
	PageSize   int              `json:"PageSize" xml:"PageSize"`
	TotalCount int64            `json:"TotalCount" xml:"TotalCount"`
	ErrorMsg   string           `json:"ErrorMsg" xml:"ErrorMsg"`
	Data       []AppGroupDetail `json:"Data" xml:"Data"`
}

// CreateListAppGroupRequest creates a request to invoke ListAppGroup API
func CreateListAppGroupRequest() (request *ListAppGroupRequest) {
	request = &ListAppGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("retailcloud", "2018-03-13", "ListAppGroup", "", "")
	request.Method = requests.POST
	return
}

// CreateListAppGroupResponse creates a response to parse from ListAppGroup response
func CreateListAppGroupResponse() (response *ListAppGroupResponse) {
	response = &ListAppGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
