package sae

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateIngress invokes the sae.CreateIngress API synchronously
func (client *Client) CreateIngress(request *CreateIngressRequest) (response *CreateIngressResponse, err error) {
	response = CreateCreateIngressResponse()
	err = client.DoAction(request, response)
	return
}

// CreateIngressWithChan invokes the sae.CreateIngress API asynchronously
func (client *Client) CreateIngressWithChan(request *CreateIngressRequest) (<-chan *CreateIngressResponse, <-chan error) {
	responseChan := make(chan *CreateIngressResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateIngress(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateIngressWithCallback invokes the sae.CreateIngress API asynchronously
func (client *Client) CreateIngressWithCallback(request *CreateIngressRequest, callback func(response *CreateIngressResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateIngressResponse
		var err error
		defer close(result)
		response, err = client.CreateIngress(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateIngressRequest is the request struct for api CreateIngress
type CreateIngressRequest struct {
	*requests.RoaRequest
	ListenerPort     requests.Integer `position:"Query" name:"ListenerPort"`
	SlbId            string           `position:"Query" name:"SlbId"`
	NamespaceId      string           `position:"Query" name:"NamespaceId"`
	Description      string           `position:"Query" name:"Description"`
	LoadBalanceType  string           `position:"Query" name:"LoadBalanceType"`
	Rules            string           `position:"Body" name:"Rules"`
	CertId           string           `position:"Query" name:"CertId"`
	CertIds          string           `position:"Query" name:"CertIds"`
	ListenerProtocol string           `position:"Query" name:"ListenerProtocol"`
	DefaultRule      string           `position:"Query" name:"DefaultRule"`
}

// CreateIngressResponse is the response struct for api CreateIngress
type CreateIngressResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Message   string `json:"Message" xml:"Message"`
	TraceId   string `json:"TraceId" xml:"TraceId"`
	ErrorCode string `json:"ErrorCode" xml:"ErrorCode"`
	Code      string `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateCreateIngressRequest creates a request to invoke CreateIngress API
func CreateCreateIngressRequest() (request *CreateIngressRequest) {
	request = &CreateIngressRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("sae", "2019-05-06", "CreateIngress", "/pop/v1/sam/ingress/Ingress", "serverless", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateIngressResponse creates a response to parse from CreateIngress response
func CreateCreateIngressResponse() (response *CreateIngressResponse) {
	response = &CreateIngressResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
