package sae

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteJob invokes the sae.DeleteJob API synchronously
func (client *Client) DeleteJob(request *DeleteJobRequest) (response *DeleteJobResponse, err error) {
	response = CreateDeleteJobResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteJobWithChan invokes the sae.DeleteJob API asynchronously
func (client *Client) DeleteJobWithChan(request *DeleteJobRequest) (<-chan *DeleteJobResponse, <-chan error) {
	responseChan := make(chan *DeleteJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteJobWithCallback invokes the sae.DeleteJob API asynchronously
func (client *Client) DeleteJobWithCallback(request *DeleteJobRequest, callback func(response *DeleteJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteJobResponse
		var err error
		defer close(result)
		response, err = client.DeleteJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteJobRequest is the request struct for api DeleteJob
type DeleteJobRequest struct {
	*requests.RoaRequest
	AppId string `position:"Query" name:"AppId"`
}

// DeleteJobResponse is the response struct for api DeleteJob
type DeleteJobResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Message   string `json:"Message" xml:"Message"`
	TraceId   string `json:"TraceId" xml:"TraceId"`
	Data      string `json:"Data" xml:"Data"`
	ErrorCode string `json:"ErrorCode" xml:"ErrorCode"`
	Code      string `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateDeleteJobRequest creates a request to invoke DeleteJob API
func CreateDeleteJobRequest() (request *DeleteJobRequest) {
	request = &DeleteJobRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("sae", "2019-05-06", "DeleteJob", "/pop/v1/sam/job/deleteJob", "serverless", "openAPI")
	request.Method = requests.DELETE
	return
}

// CreateDeleteJobResponse creates a response to parse from DeleteJob response
func CreateDeleteJobResponse() (response *DeleteJobResponse) {
	response = &DeleteJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
