package safe

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// Query invokes the safe.Query API synchronously
func (client *Client) Query(request *QueryRequest) (response *QueryResponse, err error) {
	response = CreateQueryResponse()
	err = client.DoAction(request, response)
	return
}

// QueryWithChan invokes the safe.Query API asynchronously
func (client *Client) QueryWithChan(request *QueryRequest) (<-chan *QueryResponse, <-chan error) {
	responseChan := make(chan *QueryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.Query(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryWithCallback invokes the safe.Query API asynchronously
func (client *Client) QueryWithCallback(request *QueryRequest, callback func(response *QueryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryResponse
		var err error
		defer close(result)
		response, err = client.Query(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryRequest is the request struct for api Query
type QueryRequest struct {
	*requests.RpcRequest
	AuthKey       string           `position:"Query" name:"AuthKey"`
	NeedValidate  requests.Boolean `position:"Query" name:"NeedValidate"`
	ReqTimestamp  requests.Integer `position:"Query" name:"ReqTimestamp"`
	AuthSign      string           `position:"Query" name:"AuthSign"`
	SourceOrderId string           `position:"Query" name:"SourceOrderId"`
	QueryType     string           `position:"Query" name:"QueryType"`
}

// QueryResponse is the response struct for api Query
type QueryResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      string `json:"Data" xml:"Data"`
	Code      int    `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateQueryRequest creates a request to invoke Query API
func CreateQueryRequest() (request *QueryRequest) {
	request = &QueryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Safe", "2022-01-17", "Query", "", "")
	request.Method = requests.POST
	return
}

// CreateQueryResponse creates a response to parse from Query response
func CreateQueryResponse() (response *QueryResponse) {
	response = &QueryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
