package sas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeExposedStatistics invokes the sas.DescribeExposedStatistics API synchronously
func (client *Client) DescribeExposedStatistics(request *DescribeExposedStatisticsRequest) (response *DescribeExposedStatisticsResponse, err error) {
	response = CreateDescribeExposedStatisticsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeExposedStatisticsWithChan invokes the sas.DescribeExposedStatistics API asynchronously
func (client *Client) DescribeExposedStatisticsWithChan(request *DescribeExposedStatisticsRequest) (<-chan *DescribeExposedStatisticsResponse, <-chan error) {
	responseChan := make(chan *DescribeExposedStatisticsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeExposedStatistics(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeExposedStatisticsWithCallback invokes the sas.DescribeExposedStatistics API asynchronously
func (client *Client) DescribeExposedStatisticsWithCallback(request *DescribeExposedStatisticsRequest, callback func(response *DescribeExposedStatisticsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeExposedStatisticsResponse
		var err error
		defer close(result)
		response, err = client.DescribeExposedStatistics(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeExposedStatisticsRequest is the request struct for api DescribeExposedStatistics
type DescribeExposedStatisticsRequest struct {
	*requests.RpcRequest
	SourceIp string `position:"Query" name:"SourceIp"`
}

// DescribeExposedStatisticsResponse is the response struct for api DescribeExposedStatistics
type DescribeExposedStatisticsResponse struct {
	*responses.BaseResponse
	RequestId                       string `json:"RequestId" xml:"RequestId"`
	ExposedLaterVulCount            int    `json:"ExposedLaterVulCount" xml:"ExposedLaterVulCount"`
	ExposedComponentCount           int    `json:"ExposedComponentCount" xml:"ExposedComponentCount"`
	ExposedPortCount                int    `json:"ExposedPortCount" xml:"ExposedPortCount"`
	ExposedInstanceCount            int    `json:"ExposedInstanceCount" xml:"ExposedInstanceCount"`
	ExposedWeekPasswordMachineCount int    `json:"ExposedWeekPasswordMachineCount" xml:"ExposedWeekPasswordMachineCount"`
	ExposedNntfVulCount             int    `json:"ExposedNntfVulCount" xml:"ExposedNntfVulCount"`
	GatewayAssetCount               int    `json:"GatewayAssetCount" xml:"GatewayAssetCount"`
	ExposedIpCount                  int    `json:"ExposedIpCount" xml:"ExposedIpCount"`
	ExposedAsapVulCount             int    `json:"ExposedAsapVulCount" xml:"ExposedAsapVulCount"`
}

// CreateDescribeExposedStatisticsRequest creates a request to invoke DescribeExposedStatistics API
func CreateDescribeExposedStatisticsRequest() (request *DescribeExposedStatisticsRequest) {
	request = &DescribeExposedStatisticsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sas", "2018-12-03", "DescribeExposedStatistics", "sas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeExposedStatisticsResponse creates a response to parse from DescribeExposedStatistics response
func CreateDescribeExposedStatisticsResponse() (response *DescribeExposedStatisticsResponse) {
	response = &DescribeExposedStatisticsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
