package selectdb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyBEClusterAttribute invokes the selectdb.ModifyBEClusterAttribute API synchronously
func (client *Client) ModifyBEClusterAttribute(request *ModifyBEClusterAttributeRequest) (response *ModifyBEClusterAttributeResponse, err error) {
	response = CreateModifyBEClusterAttributeResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyBEClusterAttributeWithChan invokes the selectdb.ModifyBEClusterAttribute API asynchronously
func (client *Client) ModifyBEClusterAttributeWithChan(request *ModifyBEClusterAttributeRequest) (<-chan *ModifyBEClusterAttributeResponse, <-chan error) {
	responseChan := make(chan *ModifyBEClusterAttributeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyBEClusterAttribute(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyBEClusterAttributeWithCallback invokes the selectdb.ModifyBEClusterAttribute API asynchronously
func (client *Client) ModifyBEClusterAttributeWithCallback(request *ModifyBEClusterAttributeRequest, callback func(response *ModifyBEClusterAttributeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyBEClusterAttributeResponse
		var err error
		defer close(result)
		response, err = client.ModifyBEClusterAttribute(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyBEClusterAttributeRequest is the request struct for api ModifyBEClusterAttribute
type ModifyBEClusterAttributeRequest struct {
	*requests.RpcRequest
	ResourceOwnerId       requests.Integer `position:"Query" name:"ResourceOwnerId"`
	DBClusterId           string           `position:"Query" name:"DBClusterId"`
	DBInstanceId          string           `position:"Query" name:"DBInstanceId"`
	Value                 string           `position:"Query" name:"Value"`
	InstanceAttributeType string           `position:"Query" name:"InstanceAttributeType"`
}

// ModifyBEClusterAttributeResponse is the response struct for api ModifyBEClusterAttribute
type ModifyBEClusterAttributeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyBEClusterAttributeRequest creates a request to invoke ModifyBEClusterAttribute API
func CreateModifyBEClusterAttributeRequest() (request *ModifyBEClusterAttributeRequest) {
	request = &ModifyBEClusterAttributeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("selectdb", "2023-05-22", "ModifyBEClusterAttribute", "", "")
	request.Method = requests.POST
	return
}

// CreateModifyBEClusterAttributeResponse creates a response to parse from ModifyBEClusterAttribute response
func CreateModifyBEClusterAttributeResponse() (response *ModifyBEClusterAttributeResponse) {
	response = &ModifyBEClusterAttributeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
