package sgw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CheckRole invokes the sgw.CheckRole API synchronously
func (client *Client) CheckRole(request *CheckRoleRequest) (response *CheckRoleResponse, err error) {
	response = CreateCheckRoleResponse()
	err = client.DoAction(request, response)
	return
}

// CheckRoleWithChan invokes the sgw.CheckRole API asynchronously
func (client *Client) CheckRoleWithChan(request *CheckRoleRequest) (<-chan *CheckRoleResponse, <-chan error) {
	responseChan := make(chan *CheckRoleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CheckRole(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CheckRoleWithCallback invokes the sgw.CheckRole API asynchronously
func (client *Client) CheckRoleWithCallback(request *CheckRoleRequest, callback func(response *CheckRoleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CheckRoleResponse
		var err error
		defer close(result)
		response, err = client.CheckRole(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CheckRoleRequest is the request struct for api CheckRole
type CheckRoleRequest struct {
	*requests.RpcRequest
	SecurityToken string `position:"Query" name:"SecurityToken"`
	RoleType      string `position:"Query" name:"RoleType"`
}

// CheckRoleResponse is the response struct for api CheckRole
type CheckRoleResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
}

// CreateCheckRoleRequest creates a request to invoke CheckRole API
func CreateCheckRoleRequest() (request *CheckRoleRequest) {
	request = &CheckRoleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("sgw", "2018-05-11", "CheckRole", "hcs_sgw", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCheckRoleResponse creates a response to parse from CheckRole response
func CreateCheckRoleResponse() (response *CheckRoleResponse) {
	response = &CheckRoleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
