package snsuapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BandStopSpeedUp invokes the snsuapi.BandStopSpeedUp API synchronously
// api document: https://help.aliyun.com/api/snsuapi/bandstopspeedup.html
func (client *Client) BandStopSpeedUp(request *BandStopSpeedUpRequest) (response *BandStopSpeedUpResponse, err error) {
	response = CreateBandStopSpeedUpResponse()
	err = client.DoAction(request, response)
	return
}

// BandStopSpeedUpWithChan invokes the snsuapi.BandStopSpeedUp API asynchronously
// api document: https://help.aliyun.com/api/snsuapi/bandstopspeedup.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) BandStopSpeedUpWithChan(request *BandStopSpeedUpRequest) (<-chan *BandStopSpeedUpResponse, <-chan error) {
	responseChan := make(chan *BandStopSpeedUpResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BandStopSpeedUp(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BandStopSpeedUpWithCallback invokes the snsuapi.BandStopSpeedUp API asynchronously
// api document: https://help.aliyun.com/api/snsuapi/bandstopspeedup.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) BandStopSpeedUpWithCallback(request *BandStopSpeedUpRequest, callback func(response *BandStopSpeedUpResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BandStopSpeedUpResponse
		var err error
		defer close(result)
		response, err = client.BandStopSpeedUp(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BandStopSpeedUpRequest is the request struct for api BandStopSpeedUp
type BandStopSpeedUpRequest struct {
	*requests.RpcRequest
	IpAddress            string           `position:"Query" name:"IpAddress"`
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	Port                 requests.Integer `position:"Query" name:"Port"`
	BandId               requests.Integer `position:"Query" name:"BandId"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	Direction            string           `position:"Query" name:"Direction"`
}

// BandStopSpeedUpResponse is the response struct for api BandStopSpeedUp
type BandStopSpeedUpResponse struct {
	*responses.BaseResponse
	RequestId     string `json:"RequestId" xml:"RequestId"`
	ResultCode    string `json:"ResultCode" xml:"ResultCode"`
	ResultMessage string `json:"ResultMessage" xml:"ResultMessage"`
	ResultModule  bool   `json:"ResultModule" xml:"ResultModule"`
}

// CreateBandStopSpeedUpRequest creates a request to invoke BandStopSpeedUp API
func CreateBandStopSpeedUpRequest() (request *BandStopSpeedUpRequest) {
	request = &BandStopSpeedUpRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Snsuapi", "2018-07-09", "BandStopSpeedUp", "snsuapi", "openAPI")
	return
}

// CreateBandStopSpeedUpResponse creates a response to parse from BandStopSpeedUp response
func CreateBandStopSpeedUpResponse() (response *BandStopSpeedUpResponse) {
	response = &BandStopSpeedUpResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
