package sophonsoar

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeComponentList invokes the sophonsoar.DescribeComponentList API synchronously
func (client *Client) DescribeComponentList(request *DescribeComponentListRequest) (response *DescribeComponentListResponse, err error) {
	response = CreateDescribeComponentListResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeComponentListWithChan invokes the sophonsoar.DescribeComponentList API asynchronously
func (client *Client) DescribeComponentListWithChan(request *DescribeComponentListRequest) (<-chan *DescribeComponentListResponse, <-chan error) {
	responseChan := make(chan *DescribeComponentListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeComponentList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeComponentListWithCallback invokes the sophonsoar.DescribeComponentList API asynchronously
func (client *Client) DescribeComponentListWithCallback(request *DescribeComponentListRequest, callback func(response *DescribeComponentListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeComponentListResponse
		var err error
		defer close(result)
		response, err = client.DescribeComponentList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeComponentListRequest is the request struct for api DescribeComponentList
type DescribeComponentListRequest struct {
	*requests.RpcRequest
	RoleFor      string `position:"Query" name:"RoleFor"`
	PlaybookUuid string `position:"Query" name:"PlaybookUuid"`
	RoleType     string `position:"Query" name:"RoleType"`
	Lang         string `position:"Query" name:"Lang"`
}

// DescribeComponentListResponse is the response struct for api DescribeComponentList
type DescribeComponentListResponse struct {
	*responses.BaseResponse
	RequestId  string `json:"RequestId" xml:"RequestId"`
	Components string `json:"Components" xml:"Components"`
}

// CreateDescribeComponentListRequest creates a request to invoke DescribeComponentList API
func CreateDescribeComponentListRequest() (request *DescribeComponentListRequest) {
	request = &DescribeComponentListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("sophonsoar", "2022-07-28", "DescribeComponentList", "", "")
	request.Method = requests.GET
	return
}

// CreateDescribeComponentListResponse creates a response to parse from DescribeComponentList response
func CreateDescribeComponentListResponse() (response *DescribeComponentListResponse) {
	response = &DescribeComponentListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
