package sophonsoar

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDistinctReleases invokes the sophonsoar.DescribeDistinctReleases API synchronously
func (client *Client) DescribeDistinctReleases(request *DescribeDistinctReleasesRequest) (response *DescribeDistinctReleasesResponse, err error) {
	response = CreateDescribeDistinctReleasesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDistinctReleasesWithChan invokes the sophonsoar.DescribeDistinctReleases API asynchronously
func (client *Client) DescribeDistinctReleasesWithChan(request *DescribeDistinctReleasesRequest) (<-chan *DescribeDistinctReleasesResponse, <-chan error) {
	responseChan := make(chan *DescribeDistinctReleasesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDistinctReleases(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDistinctReleasesWithCallback invokes the sophonsoar.DescribeDistinctReleases API asynchronously
func (client *Client) DescribeDistinctReleasesWithCallback(request *DescribeDistinctReleasesRequest, callback func(response *DescribeDistinctReleasesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDistinctReleasesResponse
		var err error
		defer close(result)
		response, err = client.DescribeDistinctReleases(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDistinctReleasesRequest is the request struct for api DescribeDistinctReleases
type DescribeDistinctReleasesRequest struct {
	*requests.RpcRequest
	TaskflowMd5  string `position:"Query" name:"TaskflowMd5"`
	RoleFor      string `position:"Query" name:"RoleFor"`
	PlaybookUuid string `position:"Query" name:"PlaybookUuid"`
	RoleType     string `position:"Query" name:"RoleType"`
	Lang         string `position:"Query" name:"Lang"`
}

// DescribeDistinctReleasesResponse is the response struct for api DescribeDistinctReleases
type DescribeDistinctReleasesResponse struct {
	*responses.BaseResponse
	RequestId string        `json:"RequestId" xml:"RequestId"`
	Records   []RecordsItem `json:"Records" xml:"Records"`
}

// CreateDescribeDistinctReleasesRequest creates a request to invoke DescribeDistinctReleases API
func CreateDescribeDistinctReleasesRequest() (request *DescribeDistinctReleasesRequest) {
	request = &DescribeDistinctReleasesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("sophonsoar", "2022-07-28", "DescribeDistinctReleases", "", "")
	request.Method = requests.GET
	return
}

// CreateDescribeDistinctReleasesResponse creates a response to parse from DescribeDistinctReleases response
func CreateDescribeDistinctReleasesResponse() (response *DescribeDistinctReleasesResponse) {
	response = &DescribeDistinctReleasesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
